package amf.plugins.document.webapi.parser.spec.domain

import amf.core.annotations.{AutoGeneratedName, DeclaredElement}
import amf.core.model.domain.Shape
import org.yaml.model.{YMap, YMapEntry, YNode}
import scala.language.implicitConversions

object ParsingHelpers {

  def autoGeneratedAnnotation(s: Shape): Unit = {
    if (!linkToDeclared(s) && !simpleInheritsLink(s))
      s.add(AutoGeneratedName())
  }

  private def simpleInheritsLink(s: Shape): Boolean = {
    s.inherits match {
      case Seq(simple) => simple.isLink || simple.annotations.contains(classOf[DeclaredElement])
      case _           => false
    }
  }

  private def linkToDeclared(s: Shape): Boolean = {
    s.isLink && s.annotations.contains(classOf[DeclaredElement])
  }
}

package object ConversionHelpers {
  implicit def EitherToYMap(entryOrNode: Either[YMapEntry, YNode]): YMap = entryOrNode match {
    case Left(entry) => entry.value.as[YMap]
    case Right(node) => node.as[YMap]
  }
}

