package amf.plugins.document.webapi.parser.spec.oas.parser.types

import amf.core.metamodel.Field
import amf.core.model.domain.Shape
import amf.core.parser.YMapOps
import amf.plugins.document.webapi.contexts.parser.OasLikeWebApiContext
import amf.plugins.document.webapi.parser.spec.declaration.{OasTypeParser, SchemaVersion}
import org.yaml.model.YMap

case class InnerShapeParser(key: String, field: Field, map: YMap, shape: Shape, adopt: Shape => Unit, version: SchemaVersion)(implicit ctx: OasLikeWebApiContext) {

  def parse(): Unit = {
    map.key(
      key, { entry =>
        adopt(shape)
        OasTypeParser(entry, item => item.adopted(shape.id + s"/$key"), version).parse() match {
          case Some(parsedShape) =>
            shape.set(field, parsedShape)
          case _ => // ignore
        }
      }
    )
  }
}
