/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.resolution.pipelines.compatibility.common;

import amf.core.errorhandling.ErrorHandler;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.DeclaresModel;
import amf.core.model.domain.DomainElement;
import amf.core.model.domain.NamedDomainElement;
import amf.core.resolution.stages.ResolutionStage;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.OAuth1Settings;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.SecurityScheme;
import amf.plugins.domain.webapi.models.security.Settings;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4QAC\u0006\u0002\u0002qA\u0001B\n\u0001\u0003\u0006\u0004%\u0019e\n\u0005\n]\u0001\u0011\t\u0011)A\u0005Q=BQ\u0001\r\u0001\u0005\u0002EBQA\u000e\u0001\u0007\u0002]BQa\u0013\u0001\u0005\u00021CQA\u0016\u0001\u0005\n]CQA\u0016\u0001\u0005\neCQa\u0019\u0001\u0005\u0002\u0011DQA\u001a\u0001\u0005B\u001d\u0014acU3dkJLG/_*fiRLgnZ:NCB\u0004XM\u001d\u0006\u0003\u00195\taaY8n[>t'B\u0001\b\u0010\u00035\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us*\u0011\u0001#E\u0001\na&\u0004X\r\\5oKNT!AE\n\u0002\u0015I,7o\u001c7vi&|gN\u0003\u0002\u0015+\u00051q/\u001a2ba&T!AF\f\u0002\u0011\u0011|7-^7f]RT!\u0001G\r\u0002\u000fAdWoZ5og*\t!$A\u0002b[\u001a\u001c\u0001a\u0005\u0002\u0001;A\u0011a\u0004J\u0007\u0002?)\u0011\u0001%I\u0001\u0007gR\fw-Z:\u000b\u0005I\u0011#BA\u0012\u001a\u0003\u0011\u0019wN]3\n\u0005\u0015z\"a\u0004*fg>dW\u000f^5p]N#\u0018mZ3\u0002\u0019\u0015\u0014(o\u001c:IC:$G.\u001a:\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0012\u0002\u001b\u0015\u0014(o\u001c:iC:$G.\u001b8h\u0013\ti#F\u0001\u0007FeJ|'\u000fS1oI2,'/A\u0007feJ|'\u000fS1oI2,'\u000fI\u0005\u0003M\u0011\na\u0001P5oSRtD#\u0001\u001a\u0015\u0005M*\u0004C\u0001\u001b\u0001\u001b\u0005Y\u0001\"\u0002\u0014\u0004\u0001\bA\u0013!\u00034jq>\u000bW\u000f\u001e53)\tAd\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0003V]&$\b\"B \u0005\u0001\u0004\u0001\u0015AB8bkRD'\u0007\u0005\u0002B\u00136\t!I\u0003\u0002D\t\u0006A1/Z2ve&$\u0018P\u0003\u0002F\r\u00061Qn\u001c3fYNT!\u0001F$\u000b\u0005!;\u0012A\u00023p[\u0006Lg.\u0003\u0002K\u0005\nqq*Q;uQJ\u001aV\r\u001e;j]\u001e\u001c\u0018!\u00034jq\u0006\u0003\u0018nS3z)\rAT*\u0015\u0005\u0006\u0007\u0016\u0001\rA\u0014\t\u0003\u0003>K!\u0001\u0015\"\u0003\u001dM+7-\u001e:jif\u001c6\r[3nK\")!+\u0002a\u0001'\u00061\u0011\r]5LKf\u0004\"!\u0011+\n\u0005U\u0013%AD!qS.+\u0017pU3ui&twm]\u0001\fM&D8+\u001a;uS:<7\u000f\u0006\u000291\")1I\u0002a\u0001\u001dR\u0011\u0001H\u0017\u0005\u00067\u001e\u0001\r\u0001X\u0001\u0002IB\u0011Q,Y\u0007\u0002=*\u0011ac\u0018\u0006\u0003A\n\nQ!\\8eK2L!A\u00190\u0003\u001b\u0011+7\r\\1sKNlu\u000eZ3m\u0003a\u0011X-\\8wKVs7/\u001e9q_J$X\rZ*dQ\u0016lWm\u001d\u000b\u00039\u0016DQa\u0017\u0005A\u0002q\u000bqA]3t_24X-\u0006\u0002iWR\u0011\u0011\u000e\u001e\t\u0003U.d\u0001\u0001B\u0003m\u0013\t\u0007QNA\u0001U#\tq\u0017\u000f\u0005\u0002:_&\u0011\u0001O\u000f\u0002\b\u001d>$\b.\u001b8h!\ti&/\u0003\u0002t=\nA!)Y:f+:LG\u000fC\u0003a\u0013\u0001\u0007\u0011\u000e")
public abstract class SecuritySettingsMapper
extends ResolutionStage {
    public ErrorHandler errorHandler() {
        return super.errorHandler();
    }

    public abstract void fixOauth2(OAuth2Settings var1);

    public void fixApiKey(SecurityScheme security, ApiKeySettings apiKey) {
        if (security.queryParameters().nonEmpty()) {
            apiKey.withIn("query");
            apiKey.withName(((NamedDomainElement)security.queryParameters().head()).name().value());
        } else if (security.headers().nonEmpty()) {
            apiKey.withIn("header");
            apiKey.withName(((NamedDomainElement)security.headers().head()).name().value());
        } else {
            apiKey.withIn("query");
            apiKey.withName("");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSettings(SecurityScheme security) {
        Settings settings = security.settings();
        if (settings instanceof OAuth2Settings) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)settings;
            this.fixOauth2(oAuth2Settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings instanceof ApiKeySettings) {
            ApiKeySettings apiKeySettings = (ApiKeySettings)settings;
            this.fixApiKey(security, apiKeySettings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (settings == null) {
            Object object = security.type().option().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            String string = "x-amf-apiKey";
            if (!(object != null ? !object.equals(string) : string != null)) {
                this.fixApiKey(security, security.withApiKeySettings());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void fixSettings(DeclaresModel d) {
        d.declares().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            SecuritySettingsMapper.$anonfun$fixSettings$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public DeclaresModel removeUnsupportedSchemes(DeclaresModel d) {
        Seq filteredDeclarations = (Seq)d.declares().filter((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SecuritySettingsMapper.$anonfun$removeUnsupportedSchemes$1(x0$1)));
        return d.withDeclares(filteredDeclarations, d.withDeclares$default$2());
    }

    public <T extends BaseUnit> T resolve(T model) {
        T t;
        T t2 = model;
        if (t2 instanceof DeclaresModel) {
            T t3 = t2;
            try {
                this.fixSettings((DeclaresModel)t3);
            }
            catch (Throwable throwable) {}
            t = model;
        } else {
            t = model;
        }
        return t;
    }

    public static final /* synthetic */ void $anonfun$fixSettings$2(SecuritySettingsMapper $this, DomainElement x0$1) {
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            $this.fixSettings(securityScheme);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeUnsupportedSchemes$1(DomainElement x0$1) {
        boolean bl;
        DomainElement domainElement = x0$1;
        if (domainElement instanceof SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)domainElement;
            Settings settings = securityScheme.settings();
            boolean bl2 = settings instanceof OAuth1Settings ? false : !(settings instanceof OpenIdConnectSettings);
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    public SecuritySettingsMapper(ErrorHandler errorHandler) {
        super(errorHandler);
    }
}

