/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.parser.spec.declaration;

import amf.core.annotations.ExternalFragmentRef;
import amf.core.metamodel.domain.LinkableElementModel$;
import amf.core.model.domain.Annotation;
import amf.core.model.domain.Linkable;
import amf.core.model.domain.Shape;
import amf.core.parser.Annotations;
import amf.core.parser.Annotations$;
import amf.core.parser.Fields$;
import amf.core.parser.SearchScope;
import amf.core.parser.package$;
import amf.core.utils.UriUtils$;
import amf.plugins.document.webapi.annotations.ExternalJsonSchemaShape;
import amf.plugins.document.webapi.contexts.parser.OasLikeWebApiContext;
import amf.plugins.document.webapi.contexts.parser.async.Async20WebApiContext;
import amf.plugins.document.webapi.contexts.parser.oas.Oas2WebApiContext;
import amf.plugins.document.webapi.contexts.parser.oas.Oas3WebApiContext;
import amf.plugins.document.webapi.parser.spec.common.ShapeExtensionParser;
import amf.plugins.document.webapi.parser.spec.common.YMapEntryLike;
import amf.plugins.document.webapi.parser.spec.declaration.OasTypeParser$;
import amf.plugins.document.webapi.parser.spec.declaration.SchemaVersion;
import amf.plugins.document.webapi.parser.spec.declaration.utils.JsonSchemaParsingHelper$;
import amf.plugins.document.webapi.parser.spec.package$OasDefinitions$;
import amf.plugins.domain.shapes.models.AnyShape;
import amf.plugins.domain.shapes.models.AnyShape$;
import amf.plugins.domain.shapes.models.UnresolvedShape;
import amf.plugins.domain.shapes.models.UnresolvedShape$;
import java.io.Serializable;
import org.yaml.convert.YRead;
import org.yaml.model.IllegalTypeHandler;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0010!\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00111\u0004!Q1A\u0005\u00045D\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\u0006m\u0002!\ta\u001e\u0005\n\u0003\u0007\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"!\u0006\u0001A\u0003%\u0011q\u0001\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t)\n\u0001C\u0005\u0003/C\u0011\"a(\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003\u000fA\u0011\"a)\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003\u000fAq!a*\u0001\t\u0013\tI\u000bC\u0004\u0002.\u0002!I!a,\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u0003G\u0004A\u0011BAs\u00051y\u0015m\u001d*fMB\u000b'o]3s\u0015\t\t#%A\u0006eK\u000ed\u0017M]1uS>t'BA\u0012%\u0003\u0011\u0019\b/Z2\u000b\u0005\u00152\u0013A\u00029beN,'O\u0003\u0002(Q\u00051q/\u001a2ba&T!!\u000b\u0016\u0002\u0011\u0011|7-^7f]RT!a\u000b\u0017\u0002\u000fAdWoZ5og*\tQ&A\u0002b[\u001a\u001c\u0001a\u0005\u0002\u0001aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\f1!\\1q!\tAt(D\u0001:\u0015\tQ4(A\u0003n_\u0012,GN\u0003\u0002={\u0005!\u00110Y7m\u0015\u0005q\u0014aA8sO&\u0011\u0001)\u000f\u0002\u000536\u000b\u0007/\u0001\u0003oC6,\u0007CA\"K\u001d\t!\u0005\n\u0005\u0002Fe5\taI\u0003\u0002H]\u00051AH]8pizJ!!\u0013\u001a\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013J\nqB\\1nK\u0006sgn\u001c;bi&|gn\u001d\t\u0003\u001fNk\u0011\u0001\u0015\u0006\u0003KES!A\u0015\u0017\u0002\t\r|'/Z\u0005\u0003)B\u00131\"\u00118o_R\fG/[8og\u0006\u0019\u0011m\u001d;\u0011\u0005a:\u0016B\u0001-:\u0005\u0015I\u0006+\u0019:u\u0003\u0015\tGm\u001c9u!\u0011\t4,\u00183\n\u0005q\u0013$!\u0003$v]\u000e$\u0018n\u001c82!\tq&-D\u0001`\u0015\t\u0001\u0017-\u0001\u0004e_6\f\u0017N\u001c\u0006\u0003uEK!aY0\u0003\u000bMC\u0017\r]3\u0011\u0005E*\u0017B\u000143\u0005\u0011)f.\u001b;\u0002\u000fY,'o]5p]B\u0011\u0011N[\u0007\u0002A%\u00111\u000e\t\u0002\u000e'\u000eDW-\\1WKJ\u001c\u0018n\u001c8\u0002\u0007\r$\b0F\u0001o!\ty7/D\u0001q\u0015\t)\u0013O\u0003\u0002sM\u0005A1m\u001c8uKb$8/\u0003\u0002ua\n!r*Y:MS.,w+\u001a2Ba&\u001cuN\u001c;fqR\fAa\u0019;yA\u00051A(\u001b8jiz\"\u0002\u0002_>}{z|\u0018\u0011\u0001\u000b\u0003sj\u0004\"!\u001b\u0001\t\u000b1L\u00019\u00018\t\u000bYJ\u0001\u0019A\u001c\t\u000b\u0005K\u0001\u0019\u0001\"\t\u000b5K\u0001\u0019\u0001(\t\u000bUK\u0001\u0019\u0001,\t\u000beK\u0001\u0019\u0001.\t\u000b\u001dL\u0001\u0019\u00015\u0002\u000fI+eiX&F3V\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006L1aSA\u0006\u0003!\u0011VIR0L\u000bf\u0003\u0013!\u00029beN,GCAA\u000e!\u0015\t\u0014QDA\u0011\u0013\r\tyB\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!a\n\u0002*\u00051Qn\u001c3fYNTA!a\u000b\u0002.\u000511\u000f[1qKNT!\u0001\u0019\u0016\n\t\u0005E\u0012Q\u0005\u0002\t\u0003:L8\u000b[1qK\u00069b-\u001b8e\t\u0016\u001cG.\u0019:bi&|g.\u00118e!\u0006\u00148/\u001a\u000b\u0005\u00037\t9\u0004C\u0004\u0002:5\u0001\r!a\u000f\u0002\u0003\u0015\u00042\u0001OA\u001f\u0013\r\ty$\u000f\u0002\n36\u000b\u0007/\u00128uef\fqc\u0019:fCR,G*\u001b8l)>$Um\u00197be\u0006$\u0018n\u001c8\u0015\r\u0005\u0005\u0012QIA%\u0011\u0019\t9E\u0004a\u0001\u0005\u0006)A.\u00192fY\"9\u00111\n\bA\u0002\u0005\u0005\u0012!A:\u0002+M,\u0017M]2i\u0019>\u001c\u0017\r\u001c&t_:\u001c6\r[3nCRA\u00111DA)\u0003+\nI\u0006\u0003\u0004\u0002T=\u0001\rAQ\u0001\u0002e\"1\u0011qK\bA\u0002\t\u000b\u0011\u0001\u001e\u0005\b\u0003sy\u0001\u0019AA\u001e\u0003aA\u0017M\u001c3mK:{GOR8v]\u0012T5o\u001c8TG\",W.\u0019\u000b\u000b\u00037\ty&!\u0019\u0002d\u0005\u001d\u0004BBA*!\u0001\u0007!\tC\u0004\u0002:A\u0001\r!a\u000f\t\r\u0005\u0015\u0004\u00031\u0001C\u0003A\u0011\u0018m^(s%\u0016\u001cx\u000e\u001c<fIJ+g\r\u0003\u0004\u0002jA\u0001\rAQ\u0001\u001dI\u0016\u001cG.\u0019:bi&|gNT1nK>\u0013(+Z:pYZ,GMU3g\u0003EA\u0017M\u001c3mK:{GOR8v]\u0012|\u0015m\u001d\u000b\t\u0003_\n)(a\u001e\u0002zA)\u0011'!\u001d\u0002\"%\u0019\u00111\u000f\u001a\u0003\tM{W.\u001a\u0005\b\u0003s\t\u0002\u0019AA\u001e\u0011\u0019\t)'\u0005a\u0001\u0005\"1\u0011\u0011N\tA\u0002\t\u000b\u0001e\u0019:fCR,\u0017I\u001c3SK\u001eL7\u000f^3s+:\u0014Xm]8mm\u0016$7\u000b[1qKRA\u0011qPAC\u0003\u000f\u000bY\t\u0005\u0003\u0002$\u0005\u0005\u0015\u0002BAB\u0003K\u0011q\"\u00168sKN|GN^3e'\"\f\u0007/\u001a\u0005\b\u0003s\u0011\u0002\u0019AA\u001e\u0011\u0019\tII\u0005a\u0001\u0005\u0006\u0019!/\u001a4\t\r\u00055%\u00031\u0001C\u0003\u0011!X\r\u001f;\u0002\u0019M\fg-Z!e_B$\u0018n\u001c8\u0015\u0007\u0011\f\u0019\nC\u0004\u0002LM\u0001\r!!\t\u0002!%\u001cx*Y:MS.,7i\u001c8uKb$XCAAM!\r\t\u00141T\u0005\u0004\u0003;\u0013$a\u0002\"p_2,\u0017M\\\u0001\u0015_\u0006\u001c(\u0007R3dY\u0006\u0014\u0018\r^5p]J+w-\u001a=\u0002+=\f7O\r#fG2\f'/\u0019;j_:\u0014VmZ3yA\u0005!r.Y:4\t\u0016\u001cG.\u0019:bi&|gNU3hKb\fQc\\1tg\u0011+7\r\\1sCRLwN\u001c*fO\u0016D\b%A\u0007jg\u0012+7\r\\1sCRLwN\u001c\u000b\u0005\u00033\u000bY\u000b\u0003\u0004\u0002\nf\u0001\rAQ\u0001\u0017g\u0016\f'o\u00195SK6|G/\u001a&t_:\u001c6\r[3nCRA\u00111DAY\u0003g\u000b)\f\u0003\u0004\u0002\nj\u0001\rA\u0011\u0005\u0007\u0003\u001bS\u0002\u0019\u0001\"\t\u000f\u0005e\"\u00041\u0001\u0002<\u0005\u00192m\u001c9z+:\u0014Xm]8mm\u0016$7\u000b[1qKRQ\u00111XA_\u0003\u007f\u000b\u0019-a2\u0011\u000bE\n\t(a \t\r\u0005%5\u00041\u0001C\u0011\u0019\t\tm\u0007a\u0001\u0005\u00069a-\u001e7m%\u00164\u0007bBAc7\u0001\u0007\u00111H\u0001\u0006K:$(/\u001f\u0005\b\u0003\u0013\\\u0002\u0019AA@\u0003))hN]3t_24X\rZ\u0001\u0018GJ,\u0017\r^3MS:\\Gk\u001c)beN,Gm\u00155ba\u0016$b!a\u001c\u0002P\u0006E\u0007BBAE9\u0001\u0007!\tC\u0004\u0002Tr\u0001\r!!\t\u0002\u000bMD\u0017\r]3\u0002%A\u0014x.\\8uKB\u000b'o]3e'\"\f\u0007/\u001a\u000b\u000b\u00037\tI.a7\u0002^\u0006}\u0007BBAE;\u0001\u0007!\t\u0003\u0004\u0002\u000ev\u0001\rA\u0011\u0005\u0007\u0003\u0003l\u0002\u0019\u0001\"\t\u000f\u0005\u0005X\u00041\u0001\u0002\"\u0005y!n]8o'\u000eDW-\\1TQ\u0006\u0004X-A\tqCJ\u001cXMU3n_R,7k\u00195f[\u0006$B!a\u0007\u0002h\"1\u0011\u0011\u0019\u0010A\u0002\t\u0003")
public class OasRefParser {
    private final YMap map;
    private final String name;
    private final Annotations nameAnnotations;
    private final YPart ast;
    private final Function1<Shape, BoxedUnit> adopt;
    private final SchemaVersion version;
    private final OasLikeWebApiContext ctx;
    private final String REF_KEY;
    private final String oas2DeclarationRegex;
    private final String oas3DeclarationRegex;

    public OasLikeWebApiContext ctx() {
        return this.ctx;
    }

    private String REF_KEY() {
        return this.REF_KEY;
    }

    public Option<AnyShape> parse() {
        return package$.MODULE$.YMapOps(this.map).key(this.REF_KEY()).flatMap((Function1 & Serializable & scala.Serializable)e -> {
            YType yType = e.value().tagType();
            YType yType2 = YType$.MODULE$.Null();
            YType yType3 = yType;
            Some some = !(yType2 != null ? !yType2.equals(yType3) : yType3 != null) ? new Some((Object)AnyShape$.MODULE$.apply((YPart)e)) : this.findDeclarationAndParse((YMapEntry)e);
            return some;
        });
    }

    private Option<AnyShape> findDeclarationAndParse(YMapEntry e) {
        Option<AnyShape> option;
        String rawRef = YNode$.MODULE$.toString(e.value(), (IllegalTypeHandler)this.ctx());
        String definitionName = package$OasDefinitions$.MODULE$.stripDefinitionsPrefix(rawRef, this.ctx());
        Option<AnyShape> option2 = this.ctx().declarations().findType(definitionName, (SearchScope.Scope)SearchScope.All$.MODULE$, this.ctx().declarations().findType$default$3());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AnyShape s2 = (AnyShape)some.value();
            AnyShape link = this.createLinkToDeclaration(definitionName, s2);
            this.adopt.apply((Object)link);
            option = new Option<AnyShape>((Object)link);
        } else {
            Option<YMapEntryLike> option3 = this.ctx().findLocalJSONPath(rawRef);
            Option<AnyShape> option4 = option3 instanceof Some ? this.searchLocalJsonSchema(rawRef, this.ctx().linkTypes() ? definitionName : rawRef, e) : this.searchRemoteJsonSchema(rawRef, this.ctx().linkTypes() ? definitionName : rawRef, e);
            Option<AnyShape> referencedShape = option4;
            referencedShape.foreach((Function1 & Serializable & scala.Serializable)s -> {
                this.safeAdoption(s);
                return BoxedUnit.UNIT;
            });
            option = referencedShape;
        }
        return option;
    }

    private AnyShape createLinkToDeclaration(String label, AnyShape s) {
        return (AnyShape)((Linkable)((AnyShape)s.link(label, Annotations$.MODULE$.apply(this.ast))).withName(this.name, this.nameAnnotations)).withSupportsRecursion(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<AnyShape> searchLocalJsonSchema(String r, String t, YMapEntry e) {
        Tuple2 tuple2;
        if (this.ctx().linkTypes()) {
            tuple2 = new Tuple2((Object)r, (Object)t);
        } else {
            String resolvedRef = UriUtils$.MODULE$.resolveRelativeTo(this.ctx().rootContextDocument(), r);
            tuple2 = new Tuple2((Object)resolvedRef, (Object)resolvedRef);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        String rawOrResolvedRef = (String)tuple22._1();
        String declarationNameOrResolvedRef = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)rawOrResolvedRef, (Object)declarationNameOrResolvedRef);
        Tuple2 tuple24 = tuple23;
        String rawOrResolvedRef2 = (String)tuple24._1();
        String declarationNameOrResolvedRef2 = (String)tuple24._2();
        boolean bl = false;
        Option<AnyShape> option = null;
        Option<AnyShape> option2 = this.ctx().findJsonSchema(rawOrResolvedRef2);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AnyShape s = (AnyShape)some.value();
            return new Option<AnyShape>((Object)this.createLinkToDeclaration(rawOrResolvedRef2, s));
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (this.isOasLikeContext() && this.isDeclaration(rawOrResolvedRef2) && this.ctx().isMainFileContext()) {
                return this.handleNotFoundOas(e, rawOrResolvedRef2, declarationNameOrResolvedRef2);
            }
        }
        if (!bl) throw new MatchError(option2);
        return this.handleNotFoundJsonSchema(r, e, rawOrResolvedRef2, declarationNameOrResolvedRef2);
    }

    private Option<AnyShape> handleNotFoundJsonSchema(String r, YMapEntry e, String rawOrResolvedRef, String declarationNameOrResolvedRef) {
        Some some;
        UnresolvedShape tmpShape = this.createAndRegisterUnresolvedShape(e, rawOrResolvedRef, declarationNameOrResolvedRef);
        this.ctx().registerJsonSchema(rawOrResolvedRef, tmpShape);
        Option<YMapEntryLike> option = this.ctx().findLocalJSONPath(r);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            YMapEntryLike entryLike = (YMapEntryLike)some2.value();
            String definitiveName = (String)entryLike.key().map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.as((YRead)YRead.StringYRead$.MODULE$, (IllegalTypeHandler)this.ctx())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.name);
            some = OasTypeParser$.MODULE$.apply(entryLike, definitiveName, this.adopt, this.version, this.ctx()).parse().map((Function1 & Serializable & scala.Serializable)shape -> {
                AnyShape anyShape;
                this.ctx().futureDeclarations().resolveRef(declarationNameOrResolvedRef, (Linkable)shape);
                this.ctx().registerJsonSchema(rawOrResolvedRef, (AnyShape)shape);
                if (this.ctx().linkTypes() || rawOrResolvedRef.equals("#")) {
                    Tuple2 tuple2;
                    AnyShape link = (AnyShape)shape.link(declarationNameOrResolvedRef, Annotations$.MODULE$.apply($this.ast));
                    Option<YNode> option = entryLike.key();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        YNode keyNode = (YNode)some.value();
                        String key = (String)keyNode.asScalar().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.text()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.name);
                        tuple2 = new Tuple2((Object)key, (Object)Annotations$.MODULE$.apply((YPart)keyNode));
                    } else if (None$.MODULE$.equals(option)) {
                        tuple2 = new Tuple2((Object)$this.name, (Object)Annotations$.MODULE$.apply());
                    } else {
                        throw new MatchError(option);
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    String nextName = (String)tuple22._1();
                    Annotations annotations = (Annotations)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)nextName, (Object)annotations);
                    Tuple2 tuple24 = tuple23;
                    String nextName2 = (String)tuple24._1();
                    Annotations annotations2 = (Annotations)tuple24._2();
                    anyShape = (AnyShape)link.withName(nextName2, annotations2);
                } else {
                    anyShape = shape;
                }
                return anyShape;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)tmpShape));
        } else if (None$.MODULE$.equals(option)) {
            some = new Some((Object)tmpShape);
        } else {
            throw new MatchError(option);
        }
        return some;
    }

    private Some<AnyShape> handleNotFoundOas(YMapEntry e, String rawOrResolvedRef, String declarationNameOrResolvedRef) {
        AnyShape shape = (AnyShape)AnyShape$.MODULE$.apply(this.ast).withName(this.name, this.nameAnnotations);
        UnresolvedShape tmpShape = (UnresolvedShape)((Linkable)new UnresolvedShape(Fields$.MODULE$.apply(), Annotations$.MODULE$.apply((YPart)this.map), rawOrResolvedRef, (Option<Function1<Option<String>, ShapeExtensionParser>>)None$.MODULE$, (Option<Function1<String, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)k -> {
            shape.set(LinkableElementModel$.MODULE$.TargetId(), k);
            return BoxedUnit.UNIT;
        }), false).withName(declarationNameOrResolvedRef, Annotations$.MODULE$.apply())).withSupportsRecursion(true);
        tmpShape.unresolved(declarationNameOrResolvedRef, (YPart)e, tmpShape.unresolved$default$3(), this.ctx());
        tmpShape.withContext(this.ctx());
        this.adopt.apply((Object)tmpShape);
        ((Linkable)shape.withLinkTarget(tmpShape)).withLinkLabel(declarationNameOrResolvedRef);
        this.adopt.apply((Object)shape);
        return new Some((Object)shape);
    }

    private UnresolvedShape createAndRegisterUnresolvedShape(YMapEntry e, String ref, String text) {
        UnresolvedShape tmpShape = (UnresolvedShape)((Linkable)UnresolvedShape$.MODULE$.apply(ref, (YPart)this.map).withName(text, Annotations$.MODULE$.apply())).withSupportsRecursion(true);
        tmpShape.unresolved(text, (YPart)e, tmpShape.unresolved$default$3(), this.ctx());
        tmpShape.withContext(this.ctx());
        this.adopt.apply((Object)tmpShape);
        return tmpShape;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void safeAdoption(AnyShape s) {
        AnyShape anyShape;
        Option oldId = Option$.MODULE$.apply((Object)s.id());
        this.adopt.apply((Object)s);
        AnyShape anyShape2 = s;
        if (anyShape2 != null && (anyShape = anyShape2).isLink()) {
            String string = s.id();
            String string2 = anyShape.effectiveLinkTarget(anyShape.effectiveLinkTarget$default$1()).id();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                oldId.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    s.id_$eq(x$5);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private boolean isOasLikeContext() {
        OasLikeWebApiContext oasLikeWebApiContext = this.ctx();
        boolean bl = oasLikeWebApiContext != null;
        return bl;
    }

    private String oas2DeclarationRegex() {
        return this.oas2DeclarationRegex;
    }

    private String oas3DeclarationRegex() {
        return this.oas3DeclarationRegex;
    }

    private boolean isDeclaration(String ref) {
        boolean bl;
        OasLikeWebApiContext oasLikeWebApiContext = this.ctx();
        boolean bl2 = oasLikeWebApiContext instanceof Oas2WebApiContext && ref.matches(this.oas2DeclarationRegex()) ? true : (bl = oasLikeWebApiContext instanceof Oas3WebApiContext ? true : oasLikeWebApiContext instanceof Async20WebApiContext) && ref.matches(this.oas3DeclarationRegex());
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<AnyShape> searchRemoteJsonSchema(String ref, String text, YMapEntry e) {
        Some some;
        String fullUrl = UriUtils$.MODULE$.resolveRelativeTo(this.ctx().rootContextDocument(), ref);
        boolean bl = false;
        Some some2 = null;
        Option<AnyShape> option = this.ctx().findJsonSchema(fullUrl);
        if (option instanceof Some) {
            bl = true;
            some2 = (Some)option;
            AnyShape u = (AnyShape)some2.value();
            if (u instanceof UnresolvedShape) {
                UnresolvedShape unresolvedShape = (UnresolvedShape)u;
                return this.copyUnresolvedShape(ref, fullUrl, e, unresolvedShape);
            }
        }
        if (bl) {
            AnyShape shape2 = (AnyShape)some2.value();
            return this.createLinkToParsedShape(ref, shape2);
        }
        Option<AnyShape> option2 = this.parseRemoteSchema(ref);
        if (None$.MODULE$.equals(option2)) {
            UnresolvedShape tmpShape = JsonSchemaParsingHelper$.MODULE$.createTemporaryShape((Function1<Shape, BoxedUnit>)(Function1 & Serializable & scala.Serializable)shape -> {
                this.adopt.apply((Object)shape);
                return BoxedUnit.UNIT;
            }, e, this.ctx(), fullUrl);
            ((Linkable)tmpShape.unresolved(text, (YPart)e, tmpShape.unresolved$default$3(), this.ctx())).withSupportsRecursion(true);
            some = new Some((Object)tmpShape);
            return some;
        } else {
            if (!(option2 instanceof Some)) throw new MatchError(option2);
            Some some3 = (Some)option2;
            AnyShape jsonSchemaShape = (AnyShape)some3.value();
            jsonSchemaShape.annotations().$plus$eq((Annotation)new ExternalJsonSchemaShape(e));
            some = this.ctx().declarations().fragments().contains((Object)text) ? this.promoteParsedShape(ref, text, fullUrl, jsonSchemaShape) : new Option<AnyShape>((Object)jsonSchemaShape);
        }
        return some;
    }

    private Some<UnresolvedShape> copyUnresolvedShape(String ref, String fullRef, YMapEntry entry, UnresolvedShape unresolved) {
        Annotations annots = Annotations$.MODULE$.apply(this.ast);
        UnresolvedShape copied = (UnresolvedShape)unresolved.copyShape(annots.$plus$plus$eq(unresolved.annotations().copy())).withLinkLabel(ref);
        copied.unresolved(fullRef, (YPart)entry, copied.unresolved$default$3(), this.ctx());
        this.adopt.apply((Object)copied);
        return new Some((Object)copied);
    }

    private Some<AnyShape> createLinkToParsedShape(String ref, AnyShape shape) {
        Annotations annots = Annotations$.MODULE$.apply(this.ast);
        AnyShape copied = (AnyShape)((Linkable)((AnyShape)shape.link(ref, annots)).withName(this.name, this.nameAnnotations)).withSupportsRecursion(true);
        this.adopt.apply((Object)copied);
        return new Some((Object)copied);
    }

    private Option<AnyShape> promoteParsedShape(String ref, String text, String fullRef, AnyShape jsonSchemaShape) {
        Shape promotedShape = this.ctx().declarations().promoteExternaltoDataTypeFragment(text, fullRef, jsonSchemaShape);
        return new Some((Object)((Linkable)((AnyShape)promotedShape.link(text, Annotations$.MODULE$.apply(this.ast).$plus$eq((Annotation)new ExternalFragmentRef(ref)))).withName(this.name, this.nameAnnotations)).withSupportsRecursion(true));
    }

    private Option<AnyShape> parseRemoteSchema(String fullRef) {
        return this.ctx().parseRemoteJSONPath(fullRef).map((Function1 & Serializable & scala.Serializable)shape -> {
            this.ctx().registerJsonSchema(fullRef, (AnyShape)shape);
            this.ctx().futureDeclarations().resolveRef(fullRef, (Linkable)shape);
            return shape;
        });
    }

    public OasRefParser(YMap map, String name, Annotations nameAnnotations, YPart ast, Function1<Shape, BoxedUnit> adopt, SchemaVersion version, OasLikeWebApiContext ctx) {
        this.map = map;
        this.name = name;
        this.nameAnnotations = nameAnnotations;
        this.ast = ast;
        this.adopt = adopt;
        this.version = version;
        this.ctx = ctx;
        this.REF_KEY = "$ref";
        this.oas2DeclarationRegex = "^(\\#\\/definitions\\/){1}([^/\\n])+$";
        this.oas3DeclarationRegex = "^(\\#\\/components\\/){1}((schemas|parameters|securitySchemes|requestBodies|responses|headers|examples|links|callbacks){1}\\/){1}([^/\\n])+";
    }
}

