package org.mulesoft.antlrast.ast

import org.antlr.v4.runtime.tree.{ErrorNode, ParseTreeListener, TerminalNode}
import org.antlr.v4.runtime.{ParserRuleContext, Parser => ANTLRParser}

trait ASTBuilder extends ParseTreeListener {

  val file: String

  val parser: ANTLRParser

  var builder: AST = AST()

  def buildInputContext(): ParserRuleContext

  override def visitTerminal(terminal: TerminalNode): Unit = {
    val terminalType = terminal.getSymbol.getType
    var name         = parser.getVocabulary.getSymbolicName(terminalType)
    if (name == null) {
      name = parser.getVocabulary.getDisplayName(terminalType)
    }
    val node = Terminal(name, file, Position.Zero, Position.Zero, terminal.getText)
    builder.current().children.append(node)
  }

  override def visitErrorNode(error: ErrorNode): Unit = {
    val err = Error("Error", file, Position.Zero, Position.Zero, error.getText)
    builder.error(err)
  }

  override def enterEveryRule(ctx: ParserRuleContext): Unit = {
    val idx      = ctx.getRuleIndex
    val ruleName = parser.getRuleNames()(idx)
    val node = Node(
      ruleName,
      file,
      Position(ctx.start.getLine, ctx.start.getCharPositionInLine),
      Position(ctx.stop.getLine, ctx.stop.getCharPositionInLine),
      ctx.getText
    )
    builder.push(node)
  }

  override def exitEveryRule(ctx: ParserRuleContext): Unit = builder.pop()

  def ast(): AST = builder
}
