package org.mulesoft.antlrast.ast

import org.mulesoft.common.client.lexical.{ASTElement, SourceLocation}

import scala.collection.mutable
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
trait ASTNode extends ASTElement{
  val name: String

  def printAcc(indent: Int = 0, acc: StringBuffer = new StringBuffer()): StringBuffer = {
    this match {
      case  node: Node      =>
        acc.append(s"${" " * indent} - ${node.name} ${node.location.from.toString} @ ${node.location.sourceName}\n")
        for (elem <- node.children) {
          elem.printAcc(indent + 2, acc)
        }
        acc
      case elem: Terminal => acc.append(s"${" " * indent} => ${elem.value}\n")
      case error: Error   => acc.append(s"${" " * indent} !!! ${error.message}\n")
    }
  }

  def print(): Unit               = println(printAcc().toString)
  override def toString(): String = printAcc().toString
}

@JSExportTopLevel("Node")
@JSExportAll
case class Node(override val name: String, override val location: SourceLocation, source:String,children:mutable.Buffer[ASTNode] = mutable.Buffer()) extends ASTNode

object Node {
  def ROOT: Node = Node("", SourceLocation.Unknown, "")
}

@JSExportTopLevel("Terminal")
@JSExportAll
case class Terminal(override val name: String, override val location:SourceLocation, value: String) extends ASTNode

@JSExportTopLevel("Error")
@JSExportAll
case class Error(override val name: String, override val location:SourceLocation, message: String) extends ASTNode

@JSExportTopLevel("AST")
@JSExportAll
class AST(errors: mutable.Buffer[Error] = mutable.Buffer(), stack: mutable.Buffer[Node] = mutable.Buffer(Node.ROOT)) {

  def current(): Node = stack.last

  def push(node: Node): Unit = {
    current().children.append(node)
    stack.append(node)
  }

  def pop(): Unit = {
    stack.remove(stack.length - 1)
  }

  def error(error: Error): Unit = {
    current().children.append(error)
    errors.append(error)
  }

  def root(): ASTNode = stack.head.children.head

}

object AST {
  def apply() = new AST()
}
