package org.mulesoft.antlrast.platform

import org.antlr.v4.runtime.tree.ParseTreeWalker
import org.antlr.v4.runtime.{CharStreams, CommonTokenStream}
import org.mulesoft.antlrast.ast.{AST, Parser}
import org.mulesoft.antlrast.grammars.Protobuf3ASTBuilder
import org.mulesoft.antlrast.proto3.{Protobuf3Lexer, Protobuf3Parser}

class PlatformProtobuf3Parser extends Parser {
  def parse(source: String, input: String): AST = {
    val charStream = CharStreams.fromString(input)
    val lexer      = new Protobuf3Lexer(charStream)
    val tokens     = new CommonTokenStream(lexer)
    val parser     = new Protobuf3Parser(tokens)
    val listener   = new Protobuf3ASTBuilder(source, parser)
    val ctx        = listener.buildInputContext()
    ParseTreeWalker.DEFAULT.walk(listener, ctx)
    listener.ast()
  }
}
