package org.mulesoft.antlrast.ast

import org.antlr.v4.runtime.tree.{ErrorNode, ParseTreeListener, TerminalNode}
import org.antlr.v4.runtime.{ParserRuleContext, Parser => ANTLRParser}
import org.mulesoft.antlrast.utils.SourceLocationBuilder

trait ASTBuilder extends ParseTreeListener {

  val file: String

  val parser: ANTLRParser

  var builder: AST = AST()

  def buildInputContext(): ParserRuleContext

  override def visitTerminal(terminal: TerminalNode): Unit = {
    val terminalType = terminal.getSymbol.getType
    var name         = parser.getVocabulary.getSymbolicName(terminalType)
    if (name == null) {
      name = parser.getVocabulary.getDisplayName(terminalType)
    }
    val token = terminal.getSymbol
    val node  = Terminal(name, SourceLocationBuilder(file, token, token), terminal.getText)
    builder.current().children.append(node)
  }

  override def visitErrorNode(error: ErrorNode): Unit = {
    val token = error.getSymbol
    val err   = Error("Error", SourceLocationBuilder(file, token, token), error.getText)
    builder.error(err)
  }

  override def enterEveryRule(ctx: ParserRuleContext): Unit = {
    val idx      = ctx.getRuleIndex
    val ruleName = parser.getRuleNames()(idx)
    val node     = Node(ruleName, SourceLocationBuilder(file, ctx.start, ctx.stop), ctx.getText)
    builder.push(node)
  }

  override def exitEveryRule(ctx: ParserRuleContext): Unit = builder.pop()

  def ast(): AST = builder
}
