package org.mulesoft.antlrast.utils
import org.antlr.v4.runtime.Token
import org.mulesoft.common.client.lexical.SourceLocation

object SourceLocationBuilder {
  def apply(file: String, startToken: Token, stopToken: Token): SourceLocation = {
    val startLine   = startToken.getLine
    val startColumn = startToken.getCharPositionInLine
    val endLine     = stopToken.getLine
    val endColumn   = calculateEndColumn(stopToken)
    SourceLocation(file, startLine, startColumn, endLine, endColumn)
  }
  private def calculateEndColumn(token: Token): Int = {
    token.getCharPositionInLine + (token.getStopIndex - token.getStartIndex) + 1
  }
}
