package org.mulesoft.antlrast.platform

import org.antlr.v4.runtime.tree.ParseTreeWalker
import org.antlr.v4.runtime.{CharStreams, CommonTokenStream}
import org.mulesoft.antlrast.ast.{AST, Parser}
import org.mulesoft.antlrast.errorHandler.GraphQLCustomErrorListener
import org.mulesoft.antlrast.grammars.GraphQLFederationASTBuilder
import org.mulesoft.antlrast.graphqlfederation.{GraphQLFederationLexer, GraphQLFederationParser}

class PlatformGraphQLFederationParser extends Parser {
  def parse(source: String, input: String): AST = {
    val errorListener = new GraphQLCustomErrorListener
    val charStream = CharStreams.fromString(input)
    val lexer = new GraphQLFederationLexer(charStream)
    lexer.removeErrorListeners()
    lexer.addErrorListener(errorListener)
    val tokens = new CommonTokenStream(lexer)
    val parser = new GraphQLFederationParser(tokens)
    parser.removeErrorListeners()
    parser.addErrorListener(errorListener)
    val listener   = new GraphQLFederationASTBuilder(source, parser)
    val ctx        = listener.buildInputContext()
    ParseTreeWalker.DEFAULT.walk(listener, ctx)
    listener.ast().withErrors(errorListener.errors)
  }
}
