package org.mulesoft.antlrast.platform

import org.antlr.v4.runtime.tree.ParseTreeWalker
import org.antlr.v4.runtime.{CharStreams, CommonTokenStream}
import org.mulesoft.antlrast.ast.{AST, Parser}
import org.mulesoft.antlrast.errorHandler.AntlrCustomErrorListener
import org.mulesoft.antlrast.grammars.GraphQLASTBuilder
import org.mulesoft.antlrast.graphql.{GraphQLLexer, GraphQLParser}

class PlatformGraphQLParser extends Parser {
  def parse(source: String, input: String): AST = {
    val errorListener = new AntlrCustomErrorListener
    val charStream    = CharStreams.fromString(input)
    val lexer         = new GraphQLLexer(charStream)
    lexer.removeErrorListeners()
    lexer.addErrorListener(errorListener)
    val tokens = new CommonTokenStream(lexer)
    val parser = new GraphQLParser(tokens)
    parser.removeErrorListeners()
    parser.addErrorListener(errorListener)
    val listener = new GraphQLASTBuilder(source, parser)
    val ctx      = listener.buildInputContext()
    ParseTreeWalker.DEFAULT.walk(listener, ctx)
    listener.ast().withErrors(errorListener.errors)
  }
}
