package org.mulesoft.antlrast.platform

import org.antlr.v4.runtime.tree.ParseTreeWalker
import org.antlr.v4.runtime.{CharStreams, CommonTokenStream}
import org.mulesoft.antlrast.ast.{AST, Parser}
import org.mulesoft.antlrast.errorHandler.AntlrCustomErrorListener
import org.mulesoft.antlrast.grammars.Protobuf3ASTBuilder
import org.mulesoft.antlrast.proto3.{Protobuf3Lexer, Protobuf3Parser}

class PlatformProtobuf3Parser extends Parser {
  def parse(source: String, input: String): AST = {
    val errorListener = new AntlrCustomErrorListener
    val charStream = CharStreams.fromString(input)
    val lexer      = new Protobuf3Lexer(charStream)
    lexer.removeErrorListeners()
    lexer.addErrorListener(errorListener)
    val tokens     = new CommonTokenStream(lexer)
    val parser     = new Protobuf3Parser(tokens)
    parser.removeErrorListeners()
    parser.addErrorListener(errorListener)
    val listener   = new Protobuf3ASTBuilder(source, parser)
    val ctx        = listener.buildInputContext()
    ParseTreeWalker.DEFAULT.walk(listener, ctx)
    listener.ast().withErrors(errorListener.errors)
  }
}
