/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos;

import com.github.anastaciocintra.escpos.EscPosConst;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Style
implements EscPosConst {
    private FontName fontName;
    private boolean bold;
    private Underline underline;
    private FontSize fontWidth;
    private FontSize fontHeight;
    private EscPosConst.Justification justification;
    private boolean defaultLineSpacing;
    private int lineSpacing;
    private ColorMode colorMode;

    public Style() {
        this.reset();
    }

    public Style(Style another) {
        this.setFontName(another.fontName);
        this.setBold(another.bold);
        this.setFontSize(another.fontWidth, another.fontHeight);
        this.setUnderline(another.underline);
        this.setJustification(another.justification);
        this.defaultLineSpacing = another.defaultLineSpacing;
        this.setLineSpacing(another.lineSpacing);
        this.setColorMode(another.colorMode);
    }

    public final void reset() {
        this.fontName = FontName.Font_A_Default;
        this.fontWidth = FontSize._1;
        this.fontHeight = FontSize._1;
        this.bold = false;
        this.underline = Underline.None_Default;
        this.justification = EscPosConst.Justification.Left_Default;
        this.resetLineSpacing();
        this.colorMode = ColorMode.BlackOnWhite_Default;
    }

    public final Style setFontName(FontName fontName) {
        this.fontName = fontName;
        return this;
    }

    public final Style setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public final Style setFontSize(FontSize fontWidth, FontSize fontHeight) {
        this.fontWidth = fontWidth;
        this.fontHeight = fontHeight;
        return this;
    }

    public final Style setUnderline(Underline underline) {
        this.underline = underline;
        return this;
    }

    public final Style setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public final Style setLineSpacing(int lineSpacing) throws IllegalArgumentException {
        if (lineSpacing < 0 || lineSpacing > 255) {
            throw new IllegalArgumentException("lineSpacing must be between 0 and 255");
        }
        this.defaultLineSpacing = false;
        this.lineSpacing = lineSpacing;
        return this;
    }

    public final Style resetLineSpacing() {
        this.defaultLineSpacing = true;
        this.lineSpacing = 0;
        return this;
    }

    public final Style setColorMode(ColorMode colorMode) {
        this.colorMode = colorMode;
        return this;
    }

    public byte[] getConfigBytes() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(27);
        bytes.write(77);
        bytes.write(this.fontName.value);
        bytes.write(27);
        bytes.write(69);
        int n = this.bold ? 1 : 0;
        bytes.write(n);
        n = this.fontWidth.value << 4 | this.fontHeight.value;
        bytes.write(29);
        bytes.write(33);
        bytes.write(n);
        bytes.write(27);
        bytes.write(45);
        bytes.write(this.underline.value);
        bytes.write(27);
        bytes.write(97);
        bytes.write(this.justification.value);
        if (this.defaultLineSpacing) {
            bytes.write(27);
            bytes.write(50);
        } else {
            bytes.write(27);
            bytes.write(51);
            bytes.write(this.lineSpacing);
        }
        bytes.write(29);
        bytes.write(66);
        bytes.write(this.colorMode.value);
        return bytes.toByteArray();
    }

    public static enum ColorMode {
        BlackOnWhite_Default(0),
        WhiteOnBlack(1);

        public int value;

        private ColorMode(int value) {
            this.value = value;
        }
    }

    public static enum Underline {
        None_Default(48),
        OneDotThick(49),
        TwoDotThick(50);

        public int value;

        private Underline(int value) {
            this.value = value;
        }
    }

    public static enum FontSize {
        _1(0),
        _2(1),
        _3(2),
        _4(3),
        _5(4),
        _6(5),
        _7(6),
        _8(7);

        public int value;

        private FontSize(int value) {
            this.value = value;
        }
    }

    public static enum FontName {
        Font_A_Default(48),
        Font_B(49),
        Font_C(50);

        public int value;

        private FontName(int value) {
            this.value = value;
        }
    }
}

