/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos.image;

import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import java.io.ByteArrayOutputStream;
import java.util.List;

public class BitImageWrapper
implements ImageWrapperInterface,
EscPosConst {
    private EscPosConst.Justification justification = EscPosConst.Justification.Left_Default;
    private BitImageMode mode = BitImageMode._24DotDoubleDensity_Default;

    public BitImageWrapper setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public BitImageWrapper setMode(BitImageMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public byte[] getBytes(EscPosImage image) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(27);
        bytes.write(97);
        bytes.write(this.justification.value);
        bytes.write(27);
        bytes.write(51);
        bytes.write(16);
        int nL = image.getWidthOfImageInBits() & 0xFF;
        int nH = (image.getWidthOfImageInBits() & 0xFF00) >> 8;
        List<ByteArrayOutputStream> RasterColumns = image.getRasterRows(this.mode.bitsForVerticalData);
        for (ByteArrayOutputStream rol : RasterColumns) {
            bytes.write(27);
            bytes.write(42);
            bytes.write(this.mode.value);
            bytes.write(nL);
            bytes.write(nH);
            bytes.write(rol.toByteArray(), 0, rol.size());
            bytes.write(10);
        }
        return bytes.toByteArray();
    }

    public static enum BitImageMode {
        _8DotSingleDensity(0, 8),
        _8DotDoubleDensity(1, 8),
        _24DotSingleDensity(32, 24),
        _24DotDoubleDensity_Default(33, 24);

        public int value;
        public int bitsForVerticalData;

        private BitImageMode(int value, int bitsPerSlice) {
            this.value = value;
            this.bitsForVerticalData = bitsPerSlice;
        }
    }
}

