/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos.image;

import com.github.anastaciocintra.escpos.image.Bitonal;
import java.util.HashSet;
import java.util.Random;

public class BitonalOrderedDither
extends Bitonal {
    private final String ErrorMatrixSize = "matrixWidth and matrixHeight must be > 0";
    private final String ErrorthreshoudVal = "values of threshould must be between 0 and 255";
    private int[][] ditherMatrix;
    private final int matrixWidth;
    private final int matrixHeight;

    public BitonalOrderedDither(int matrixWidth, int matrixHeight) {
        if (matrixWidth < 1) {
            throw new IllegalArgumentException("matrixWidth and matrixHeight must be > 0");
        }
        if (matrixHeight < 1) {
            throw new IllegalArgumentException("matrixWidth and matrixHeight must be > 0");
        }
        this.matrixWidth = matrixWidth;
        this.matrixHeight = matrixHeight;
        this.ditherMatrix = new int[this.matrixWidth][this.matrixHeight];
    }

    public BitonalOrderedDither(int matrixWidth, int matrixHeight, int thresholdMin, int thresholdMax) {
        this(matrixWidth, matrixHeight);
        if (thresholdMin < 0 || thresholdMin > 255) {
            throw new IllegalArgumentException("values of threshould must be between 0 and 255");
        }
        if (thresholdMax < 0 || thresholdMax > 255) {
            throw new IllegalArgumentException("values of threshould must be between 0 and 255");
        }
        if (thresholdMax < thresholdMin) {
            throw new IllegalArgumentException("thresholdMax must be >= thresholdMin");
        }
        float matrixSize = matrixWidth * matrixHeight;
        float thresholdUtil = thresholdMax - thresholdMin;
        float valueToBeAddedOnEachPosition = thresholdUtil / (matrixSize - 1.0f);
        float positionValue = thresholdMin;
        Random randomCoordinates = new Random(1L);
        int[] shuffledX = this.shuffle(matrixWidth, randomCoordinates);
        int[] shuffledY = this.shuffle(matrixHeight, randomCoordinates);
        for (int x = 0; x < matrixWidth; ++x) {
            for (int y = 0; y < matrixHeight; ++y) {
                this.ditherMatrix[shuffledX[x]][shuffledY[y]] = Math.round(positionValue);
                positionValue += valueToBeAddedOnEachPosition;
            }
        }
    }

    private int[] shuffle(int size, Random random) {
        HashSet<Integer> set = new HashSet<Integer>();
        int[] intArray = new int[size];
        int i = 0;
        while (set.size() < size) {
            int val = random.nextInt(size);
            if (set.contains(val)) continue;
            set.add(val);
            intArray[i++] = val;
        }
        return intArray;
    }

    public BitonalOrderedDither() {
        this(2, 2, 64, 127);
    }

    public void setDitherMatrix(int[][] ditherMatrix) {
        this.ditherMatrix = ditherMatrix;
    }

    @Override
    public int zeroOrOne(int alpha, int red, int green, int blue, int x, int y) {
        int threshold;
        int luminance = 255;
        if (alpha > 127) {
            luminance = (red + green + blue) / 3;
        }
        return luminance < (threshold = this.ditherMatrix[x % this.matrixWidth][y % this.matrixHeight]) ? 1 : 0;
    }
}

