/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.transitions.everywhere.IntProperty;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionUtils;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.utils.AnimatorUtils;
import android.transitions.everywhere.utils.RectEvaluator;
import android.transitions.everywhere.utils.ViewGroupUtils;
import android.transitions.everywhere.utils.ViewOverlayUtils;
import android.transitions.everywhere.utils.ViewUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

@TargetApi(value=11)
public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    int[] tempLocation = new int[2];
    boolean mResizeClip = false;
    boolean mReparent = false;
    private static final String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator;
    private static DrawableOriginProperty sDrawableOriginProperty;

    public ChangeBounds() {
    }

    public ChangeBounds(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (ViewUtils.isLaidOut(view, false) || view.getWidth() != 0 || view.getHeight() != 0) {
            values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            values.values.put(PROPNAME_PARENT, values.view.getParent());
            if (this.mReparent) {
                values.view.getLocationInWindow(this.tempLocation);
                values.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
                values.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
            }
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private boolean parentMatches(View startParent, View endParent) {
        boolean parentMatches = true;
        if (this.mReparent) {
            TransitionValues endValues = this.getMatchedTransitionValues(startParent, true);
            parentMatches = endValues == null ? startParent == endParent : endParent == endValues.view;
        }
        return parentMatches;
    }

    @Override
    public Animator createAnimator(final ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        if (sRectEvaluator == null) {
            sRectEvaluator = new RectEvaluator();
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view = endValues.view;
        if (this.parentMatches((View)startParent, (View)endParent)) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 || endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft || startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight || startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    Animator anim;
                    if (startWidth == endWidth && startHeight == endHeight && Build.VERSION.SDK_INT >= 14) {
                        view.offsetLeftAndRight(startLeft - view.getLeft());
                        view.offsetTopAndBottom(startTop - view.getTop());
                        anim = AnimatorUtils.ofInt((Transition)this, (Object)view, new HorizontalOffsetProperty(), new VerticalOffsetProperty(), 0, 0, endLeft - startLeft, endTop - startTop);
                    } else {
                        if (startLeft != endLeft) {
                            view.setLeft(startLeft);
                        }
                        if (startTop != endTop) {
                            view.setTop(startTop);
                        }
                        if (startRight != endRight) {
                            view.setRight(startRight);
                        }
                        if (startBottom != endBottom) {
                            view.setBottom(startBottom);
                        }
                        ObjectAnimator topLeftAnimator = AnimatorUtils.ofInt((Transition)this, (Object)view, "left", "top", startLeft, startTop, endLeft, endTop);
                        ObjectAnimator bottomRightAnimator = AnimatorUtils.ofInt((Transition)this, (Object)view, "right", "bottom", startRight, startBottom, endRight, endBottom);
                        anim = TransitionUtils.mergeAnimators((Animator)topLeftAnimator, (Animator)bottomRightAnimator);
                    }
                    if (view.getParent() instanceof ViewGroup) {
                        final ViewGroup parent = (ViewGroup)view.getParent();
                        ViewGroupUtils.suppressLayout(parent, true);
                        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                            boolean mCanceled = false;

                            @Override
                            public void onTransitionCancel(Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, false);
                                this.mCanceled = true;
                            }

                            @Override
                            public void onTransitionEnd(Transition transition) {
                                if (!this.mCanceled) {
                                    ViewGroupUtils.suppressLayout(parent, false);
                                }
                            }

                            @Override
                            public void onTransitionPause(Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, false);
                            }

                            @Override
                            public void onTransitionResume(Transition transition) {
                                ViewGroupUtils.suppressLayout(parent, true);
                            }
                        };
                        this.addListener(transitionListener);
                    }
                    return anim;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX((float)(startLeft - endLeft));
                }
                if (startTop != endTop) {
                    view.setTranslationY((float)(startTop - endTop));
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                numChanges = 0;
                if (transXDelta != 0.0f) {
                    ++numChanges;
                }
                if (transYDelta != 0.0f) {
                    ++numChanges;
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    ++numChanges;
                }
                ObjectAnimator translationAnimator = AnimatorUtils.ofFloat(this, view, "translationX", "translationY", 0.0f, 0.0f, transXDelta, transYDelta);
                ObjectAnimator clipAnimator = null;
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect tempEndBounds = new Rect(0, 0, endWidth, endHeight);
                    clipAnimator = ObjectAnimator.ofObject((Object)view, (String)"clipBounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{tempStartBounds, tempEndBounds});
                }
                Animator anim = TransitionUtils.mergeAnimators((Animator)translationAnimator, clipAnimator);
                if (view.getParent() instanceof ViewGroup) {
                    final ViewGroup parent = (ViewGroup)view.getParent();
                    ViewGroupUtils.suppressLayout(parent, true);
                    Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        @Override
                        public void onTransitionCancel(Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, false);
                            this.mCanceled = true;
                        }

                        @Override
                        public void onTransitionEnd(Transition transition) {
                            if (!this.mCanceled) {
                                ViewGroupUtils.suppressLayout(parent, false);
                            }
                        }

                        @Override
                        public void onTransitionPause(Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, false);
                        }

                        @Override
                        public void onTransitionResume(Transition transition) {
                            ViewGroupUtils.suppressLayout(parent, true);
                        }
                    };
                    this.addListener(transitionListener);
                }
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewUtils.setClipBounds(view, null);
                    }
                });
                return anim;
            }
        } else {
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X);
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y);
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X);
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y);
            if (startX != endX || startY != endY) {
                ObjectAnimator anim;
                sceneRoot.getLocationInWindow(this.tempLocation);
                Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                final BitmapDrawable drawable = new BitmapDrawable(sceneRoot.getContext().getResources(), bitmap);
                final float transitionAlpha = ViewUtils.getTransitionAlpha(view);
                ViewUtils.setTransitionAlpha(view, 0.0f);
                ViewOverlayUtils.addOverlay(sceneRoot, (Drawable)drawable);
                if (Build.VERSION.SDK_INT >= 21) {
                    if (sDrawableOriginProperty == null) {
                        sDrawableOriginProperty = new DrawableOriginProperty();
                    }
                    Path topLeftPath = this.getPathMotion().getPath(startX - this.tempLocation[0], startY - this.tempLocation[1], endX - this.tempLocation[0], endY - this.tempLocation[1]);
                    PropertyValuesHolder origin = AnimatorUtils.pvhOfObject(sDrawableOriginProperty, null, topLeftPath);
                    anim = ObjectAnimator.ofPropertyValuesHolder((Object)drawable, (PropertyValuesHolder[])new PropertyValuesHolder[]{origin});
                } else {
                    Rect startBounds1 = new Rect(startX - this.tempLocation[0], startY - this.tempLocation[1], startX - this.tempLocation[0] + view.getWidth(), startY - this.tempLocation[1] + view.getHeight());
                    Rect endBounds1 = new Rect(endX - this.tempLocation[0], endY - this.tempLocation[1], endX - this.tempLocation[0] + view.getWidth(), endY - this.tempLocation[1] + view.getHeight());
                    anim = ObjectAnimator.ofObject((Object)drawable, (String)"bounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{startBounds1, endBounds1});
                }
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewOverlayUtils.removeOverlay(sceneRoot, (Drawable)drawable);
                        ViewUtils.setTransitionAlpha(view, transitionAlpha);
                    }
                });
                return anim;
            }
        }
        return null;
    }

    @TargetApi(value=21)
    private static class DrawableOriginProperty
    extends Property<Drawable, PointF> {
        private Rect mBounds = new Rect();

        private DrawableOriginProperty() {
            super(PointF.class, "boundsOrigin");
        }

        public void set(Drawable object, PointF value) {
            object.copyBounds(this.mBounds);
            this.mBounds.offsetTo(Math.round(value.x), Math.round(value.y));
            object.setBounds(this.mBounds);
        }

        public PointF get(Drawable object) {
            object.copyBounds(this.mBounds);
            return new PointF((float)this.mBounds.left, (float)this.mBounds.top);
        }
    }

    private static class VerticalOffsetProperty
    extends OffsetProperty {
        public VerticalOffsetProperty() {
            super("offsetTopAndBottom");
        }

        @Override
        protected void offsetBy(View view, int by) {
            view.offsetTopAndBottom(by);
        }
    }

    private static class HorizontalOffsetProperty
    extends OffsetProperty {
        public HorizontalOffsetProperty() {
            super("offsetLeftAndRight");
        }

        @Override
        protected void offsetBy(View view, int by) {
            view.offsetLeftAndRight(by);
        }
    }

    private static abstract class OffsetProperty
    extends IntProperty<View> {
        int mPreviousValue;

        public OffsetProperty(String name) {
            super(name);
        }

        @Override
        public void setValue(View view, int value) {
            int offset = value - this.mPreviousValue;
            this.offsetBy(view, offset);
            this.mPreviousValue = value;
        }

        public Integer get(View object) {
            return null;
        }

        protected abstract void offsetBy(View var1, int var2);
    }
}

