/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.os.Build;
import android.transitions.everywhere.R;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionUtils;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.utils.MatrixUtils;
import android.transitions.everywhere.utils.ViewUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=21)
public class ChangeTransform
extends Transition {
    private static final String TAG = "ChangeTransform";
    private static final String PROPNAME_MATRIX = "android:changeTransform:matrix";
    private static final String PROPNAME_TRANSFORMS = "android:changeTransform:transforms";
    private static final String PROPNAME_PARENT = "android:changeTransform:parent";
    private static final String PROPNAME_PARENT_MATRIX = "android:changeTransform:parentMatrix";
    private static final String PROPNAME_INTERMEDIATE_PARENT_MATRIX = "android:changeTransform:intermediateParentMatrix";
    private static final String PROPNAME_INTERMEDIATE_MATRIX = "android:changeTransform:intermediateMatrix";
    private static final String[] sTransitionProperties = new String[]{"android:changeTransform:matrix", "android:changeTransform:transforms", "android:changeTransform:parentMatrix"};
    private static final Property<View, Matrix> ANIMATION_MATRIX_PROPERTY = new Property<View, Matrix>(Matrix.class, "animationMatrix"){

        public Matrix get(View object) {
            return null;
        }

        public void set(View object, Matrix value) {
            ViewUtils.setAnimationMatrix(object, value);
        }
    };
    private boolean mUseOverlay = true;
    private boolean mReparent = true;
    private Matrix mTempMatrix = new Matrix();

    public ChangeTransform() {
    }

    public ChangeTransform(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ChangeTransform);
        this.mUseOverlay = a.getBoolean(R.styleable.ChangeTransform_reparentWithOverlay, true);
        this.mReparent = a.getBoolean(R.styleable.ChangeTransform_reparent, true);
        a.recycle();
    }

    public boolean getReparentWithOverlay() {
        return this.mUseOverlay;
    }

    public void setReparentWithOverlay(boolean reparentWithOverlay) {
        this.mUseOverlay = reparentWithOverlay;
    }

    public boolean getReparent() {
        return this.mReparent;
    }

    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    private void captureValues(TransitionValues transitionValues) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        View view = transitionValues.view;
        if (view.getVisibility() == 8) {
            return;
        }
        transitionValues.values.put(PROPNAME_PARENT, view.getParent());
        Transforms transforms = new Transforms(view);
        transitionValues.values.put(PROPNAME_TRANSFORMS, transforms);
        Object matrix = view.getMatrix();
        matrix = matrix == null || matrix.isIdentity() ? null : new Matrix(matrix);
        transitionValues.values.put(PROPNAME_MATRIX, matrix);
        if (this.mReparent) {
            Matrix parentMatrix = new Matrix();
            ViewGroup parent = (ViewGroup)view.getParent();
            ViewUtils.transformMatrixToGlobal((View)parent, parentMatrix);
            parentMatrix.preTranslate((float)(-parent.getScrollX()), (float)(-parent.getScrollY()));
            transitionValues.values.put(PROPNAME_PARENT_MATRIX, parentMatrix);
            transitionValues.values.put(PROPNAME_INTERMEDIATE_MATRIX, view.getTag(R.id.transitionTransform));
            transitionValues.values.put(PROPNAME_INTERMEDIATE_PARENT_MATRIX, view.getTag(R.id.parentMatrix));
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        Matrix startParentMatrix;
        if (startValues == null || endValues == null || Build.VERSION.SDK_INT < 21 || !startValues.values.containsKey(PROPNAME_PARENT) || !endValues.values.containsKey(PROPNAME_PARENT)) {
            return null;
        }
        ViewGroup startParent = (ViewGroup)startValues.values.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endValues.values.get(PROPNAME_PARENT);
        boolean handleParentChange = this.mReparent && !this.parentsMatch(startParent, endParent);
        Matrix startMatrix = (Matrix)startValues.values.get(PROPNAME_INTERMEDIATE_MATRIX);
        if (startMatrix != null) {
            startValues.values.put(PROPNAME_MATRIX, startMatrix);
        }
        if ((startParentMatrix = (Matrix)startValues.values.get(PROPNAME_INTERMEDIATE_PARENT_MATRIX)) != null) {
            startValues.values.put(PROPNAME_PARENT_MATRIX, startParentMatrix);
        }
        if (handleParentChange) {
            this.setMatricesForParent(startValues, endValues);
        }
        ObjectAnimator transformAnimator = this.createTransformAnimator(startValues, endValues, handleParentChange);
        if (handleParentChange && transformAnimator != null && this.mUseOverlay) {
            this.createGhostView(sceneRoot, startValues, endValues);
        }
        return transformAnimator;
    }

    private ObjectAnimator createTransformAnimator(TransitionValues startValues, TransitionValues endValues, final boolean handleParentChange) {
        Matrix startMatrix = (Matrix)startValues.values.get(PROPNAME_MATRIX);
        Matrix endMatrix = (Matrix)endValues.values.get(PROPNAME_MATRIX);
        if (startMatrix == null) {
            startMatrix = MatrixUtils.IDENTITY_MATRIX;
        }
        if (endMatrix == null) {
            endMatrix = MatrixUtils.IDENTITY_MATRIX;
        }
        if (startMatrix.equals((Object)endMatrix)) {
            return null;
        }
        final Transforms transforms = (Transforms)endValues.values.get(PROPNAME_TRANSFORMS);
        final View view = endValues.view;
        ChangeTransform.setIdentityTransforms(view);
        ObjectAnimator animator = ObjectAnimator.ofObject((Object)view, ANIMATION_MATRIX_PROPERTY, (TypeEvaluator)new TransitionUtils.MatrixEvaluator(), (Object[])new Matrix[]{startMatrix, endMatrix});
        final Matrix finalEndMatrix = endMatrix;
        AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){
            private boolean mIsCanceled;
            private Matrix mTempMatrix = new Matrix();

            public void onAnimationCancel(Animator animation) {
                this.mIsCanceled = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.mIsCanceled) {
                    if (handleParentChange && ChangeTransform.this.mUseOverlay) {
                        this.setCurrentMatrix(finalEndMatrix);
                    } else {
                        view.setTag(R.id.transitionTransform, null);
                        view.setTag(R.id.parentMatrix, null);
                    }
                }
                ANIMATION_MATRIX_PROPERTY.set((Object)view, null);
                transforms.restore(view);
            }

            public void onAnimationPause(Animator animation) {
                ValueAnimator animator = (ValueAnimator)animation;
                Matrix currentMatrix = (Matrix)animator.getAnimatedValue();
                this.setCurrentMatrix(currentMatrix);
            }

            public void onAnimationResume(Animator animation) {
                ChangeTransform.setIdentityTransforms(view);
            }

            private void setCurrentMatrix(Matrix currentMatrix) {
                this.mTempMatrix.set(currentMatrix);
                view.setTag(R.id.transitionTransform, (Object)this.mTempMatrix);
                transforms.restore(view);
            }
        };
        animator.addListener((Animator.AnimatorListener)listener);
        animator.addPauseListener((Animator.AnimatorPauseListener)listener);
        return animator;
    }

    private boolean parentsMatch(ViewGroup startParent, ViewGroup endParent) {
        boolean parentsMatch = false;
        if (!this.isValidTarget((View)startParent) || !this.isValidTarget((View)endParent)) {
            parentsMatch = startParent == endParent;
        } else {
            TransitionValues endValues = this.getMatchedTransitionValues((View)startParent, true);
            if (endValues != null) {
                parentsMatch = endParent == endValues.view;
            }
        }
        return parentsMatch;
    }

    private void createGhostView(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        View view = endValues.view;
        Matrix endMatrix = (Matrix)endValues.values.get(PROPNAME_PARENT_MATRIX);
        Matrix localEndMatrix = new Matrix(endMatrix);
        ViewUtils.transformMatrixToLocal((View)sceneRoot, localEndMatrix);
        Transition outerTransition = this;
        while (outerTransition.mParent != null) {
            outerTransition = outerTransition.mParent;
        }
        View ghostView = ViewUtils.addGhostView(view, sceneRoot, localEndMatrix);
        if (ghostView != null) {
            GhostListener listener = new GhostListener(view, ghostView, endMatrix);
            outerTransition.addListener(listener);
        }
        if (startValues.view != endValues.view) {
            ViewUtils.setTransitionAlpha(view, 0.0f);
        }
        ViewUtils.setTransitionAlpha(view, 1.0f);
    }

    private void setMatricesForParent(TransitionValues startValues, TransitionValues endValues) {
        Matrix endParentMatrix = (Matrix)endValues.values.get(PROPNAME_PARENT_MATRIX);
        endValues.view.setTag(R.id.parentMatrix, (Object)endParentMatrix);
        Matrix toLocal = this.mTempMatrix;
        toLocal.reset();
        endParentMatrix.invert(toLocal);
        Matrix startLocal = (Matrix)startValues.values.get(PROPNAME_MATRIX);
        if (startLocal == null) {
            startLocal = new Matrix();
            startValues.values.put(PROPNAME_MATRIX, startLocal);
        }
        Matrix startParentMatrix = (Matrix)startValues.values.get(PROPNAME_PARENT_MATRIX);
        startLocal.postConcat(startParentMatrix);
        startLocal.postConcat(toLocal);
    }

    private static void setIdentityTransforms(View view) {
        ChangeTransform.setTransforms(view, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    private static void setTransforms(View view, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float rotationX, float rotationY, float rotationZ) {
        view.setTranslationX(translationX);
        view.setTranslationY(translationY);
        ViewUtils.setTranslationZ(view, translationZ);
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setRotationX(rotationX);
        view.setRotationY(rotationY);
        view.setRotation(rotationZ);
    }

    private static class GhostListener
    extends Transition.TransitionListenerAdapter {
        private View mView;
        private View mGhostView;
        private Matrix mEndMatrix;

        public GhostListener(View view, View ghostView, Matrix endMatrix) {
            this.mView = view;
            this.mGhostView = ghostView;
            this.mEndMatrix = endMatrix;
        }

        @Override
        public void onTransitionEnd(Transition transition) {
            transition.removeListener(this);
            ViewUtils.removeGhostView(this.mView);
            this.mView.setTag(R.id.transitionTransform, null);
            this.mView.setTag(R.id.parentMatrix, null);
        }

        @Override
        public void onTransitionPause(Transition transition) {
            this.mGhostView.setVisibility(4);
        }

        @Override
        public void onTransitionResume(Transition transition) {
            this.mGhostView.setVisibility(0);
        }
    }

    private static class Transforms {
        public final float translationX;
        public final float translationY;
        public final float translationZ;
        public final float scaleX;
        public final float scaleY;
        public final float rotationX;
        public final float rotationY;
        public final float rotationZ;

        public Transforms(View view) {
            this.translationX = view.getTranslationX();
            this.translationY = view.getTranslationY();
            this.translationZ = ViewUtils.getTranslationZ(view);
            this.scaleX = view.getScaleX();
            this.scaleY = view.getScaleY();
            this.rotationX = view.getRotationX();
            this.rotationY = view.getRotationY();
            this.rotationZ = view.getRotation();
        }

        public void restore(View view) {
            ChangeTransform.setTransforms(view, this.translationX, this.translationY, this.translationZ, this.scaleX, this.scaleY, this.rotationX, this.rotationY, this.rotationZ);
        }

        public boolean equals(Object that) {
            if (!(that instanceof Transforms)) {
                return false;
            }
            Transforms thatTransform = (Transforms)that;
            return thatTransform.translationX == this.translationX && thatTransform.translationY == this.translationY && thatTransform.translationZ == this.translationZ && thatTransform.scaleX == this.scaleX && thatTransform.scaleY == this.scaleY && thatTransform.rotationX == this.rotationX && thatTransform.rotationY == this.rotationY && thatTransform.rotationZ == this.rotationZ;
        }
    }
}

