/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.VisibilityPropagation;
import android.util.FloatMath;
import android.view.ViewGroup;

@TargetApi(value=11)
public class CircularPropagation
extends VisibilityPropagation {
    private static final String TAG = "CircularPropagation";
    private float mPropagationSpeed = 3.0f;

    public void setPropagationSpeed(float propagationSpeed) {
        if (propagationSpeed == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = propagationSpeed;
    }

    @Override
    public long getStartDelay(ViewGroup sceneRoot, Transition transition, TransitionValues startValues, TransitionValues endValues) {
        int epicenterY;
        int epicenterX;
        TransitionValues positionValues;
        if (startValues == null && endValues == null) {
            return 0L;
        }
        int directionMultiplier = 1;
        if (endValues == null || this.getViewVisibility(startValues) == 0) {
            positionValues = startValues;
            directionMultiplier = -1;
        } else {
            positionValues = endValues;
        }
        int viewCenterX = this.getViewX(positionValues);
        int viewCenterY = this.getViewY(positionValues);
        Rect epicenter = transition.getEpicenter();
        if (epicenter != null) {
            epicenterX = epicenter.centerX();
            epicenterY = epicenter.centerY();
        } else {
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            epicenterX = Math.round((float)(loc[0] + sceneRoot.getWidth() / 2) + sceneRoot.getTranslationX());
            epicenterY = Math.round((float)(loc[1] + sceneRoot.getHeight() / 2) + sceneRoot.getTranslationY());
        }
        float distance = CircularPropagation.distance(viewCenterX, viewCenterY, epicenterX, epicenterY);
        float maxDistance = CircularPropagation.distance(0.0f, 0.0f, sceneRoot.getWidth(), sceneRoot.getHeight());
        float distanceFraction = distance / maxDistance;
        long duration = transition.getDuration();
        if (duration < 0L) {
            duration = 300L;
        }
        return Math.round((float)(duration * (long)directionMultiplier) / this.mPropagationSpeed * distanceFraction);
    }

    private static float distance(float x1, float y1, float x2, float y2) {
        float x = x2 - x1;
        float y = y2 - y1;
        return FloatMath.sqrt((float)(x * x + y * y));
    }
}

