/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.transitions.everywhere.R;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.Visibility;
import android.transitions.everywhere.utils.AnimatorUtils;
import android.transitions.everywhere.utils.ViewUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=11)
public class Fade
extends Visibility {
    private static final String LOG_TAG = "Fade";
    public static final int IN = 1;
    public static final int OUT = 2;

    public Fade() {
    }

    public Fade(int fadingMode) {
        this.setMode(fadingMode);
    }

    public Fade(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Fade);
        int fadingMode = a.getInt(R.styleable.Fade_fadingMode, this.getMode());
        this.setMode(fadingMode);
    }

    private Animator createAnimation(View view, float startAlpha, float endAlpha) {
        if (startAlpha == endAlpha) {
            return null;
        }
        ViewUtils.setTransitionAlpha(view, startAlpha);
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)ViewUtils.getAlphaProperty(), (float[])new float[]{endAlpha});
        FadeAnimatorListener listener = new FadeAnimatorListener(view);
        anim.addListener((Animator.AnimatorListener)listener);
        AnimatorUtils.addPauseListener((Animator)anim, (Animator.AnimatorPauseListener)listener);
        return anim;
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimation(view, 0.0f, 1.0f);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return this.createAnimation(view, 1.0f, 0.0f);
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter {
        private final View mView;
        private boolean mCanceled = false;
        private float mPausedAlpha = -1.0f;
        private boolean mLayerTypeChanged = false;

        public FadeAnimatorListener(View view) {
            this.mView = view;
        }

        public void onAnimationStart(Animator animator) {
            if (AnimatorUtils.hasOverlappingRendering(this.mView) && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }

        public void onAnimationCancel(Animator animator) {
            this.mCanceled = true;
            if (this.mPausedAlpha >= 0.0f) {
                ViewUtils.setTransitionAlpha(this.mView, this.mPausedAlpha);
            }
        }

        public void onAnimationEnd(Animator animator) {
            if (!this.mCanceled) {
                ViewUtils.setTransitionAlpha(this.mView, 1.0f);
            }
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
        }

        public void onAnimationPause(Animator animator) {
            this.mPausedAlpha = ViewUtils.getTransitionAlpha(this.mView);
            ViewUtils.setTransitionAlpha(this.mView, 1.0f);
        }

        public void onAnimationResume(Animator animator) {
            ViewUtils.setTransitionAlpha(this.mView, this.mPausedAlpha);
        }
    }
}

