/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.content.Context;
import android.transitions.everywhere.R;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public final class Scene {
    private Context mContext;
    private int mLayoutId = -1;
    private ViewGroup mSceneRoot;
    private View mLayout;
    Runnable mEnterAction;
    Runnable mExitAction;
    private static ThreadLocal<SparseArray<Scene>> sScenes = new ThreadLocal();

    public static Scene getSceneForLayout(ViewGroup sceneRoot, int layoutId, Context context) {
        Scene scene;
        SparseArray scenes = sScenes.get();
        if (scenes == null) {
            scenes = new SparseArray();
            sScenes.set((SparseArray<Scene>)scenes);
        }
        if ((scene = (Scene)scenes.get(layoutId)) != null) {
            scene.mSceneRoot = sceneRoot;
            return scene;
        }
        scene = new Scene(sceneRoot, layoutId, context);
        scenes.put(layoutId, (Object)scene);
        return scene;
    }

    public Scene(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
    }

    private Scene(ViewGroup sceneRoot, int layoutId, Context context) {
        this.mContext = context;
        this.mSceneRoot = sceneRoot;
        this.mLayoutId = layoutId;
    }

    public Scene(ViewGroup sceneRoot, View layout) {
        this.mSceneRoot = sceneRoot;
        this.mLayout = layout;
    }

    @Deprecated
    public Scene(ViewGroup sceneRoot, ViewGroup layout) {
        this.mSceneRoot = sceneRoot;
        this.mLayout = layout;
    }

    public ViewGroup getSceneRoot() {
        return this.mSceneRoot;
    }

    public void exit() {
        if (Scene.getCurrentScene((View)this.mSceneRoot) == this && this.mExitAction != null) {
            this.mExitAction.run();
        }
    }

    public void enter() {
        if (this.mLayoutId > 0 || this.mLayout != null) {
            this.getSceneRoot().removeAllViews();
            if (this.mLayoutId > 0) {
                LayoutInflater.from((Context)this.mContext).inflate(this.mLayoutId, this.mSceneRoot);
            } else {
                this.mSceneRoot.addView(this.mLayout);
            }
        }
        if (this.mEnterAction != null) {
            this.mEnterAction.run();
        }
        Scene.setCurrentScene((View)this.mSceneRoot, this);
    }

    static void setCurrentScene(View view, Scene scene) {
        view.setTag(R.id.current_scene, (Object)scene);
    }

    static Scene getCurrentScene(View view) {
        return (Scene)view.getTag(R.id.current_scene);
    }

    public void setEnterAction(Runnable action) {
        this.mEnterAction = action;
    }

    public void setExitAction(Runnable action) {
        this.mExitAction = action;
    }

    boolean isCreatedFromLayoutResource() {
        return this.mLayoutId > 0;
    }
}

