/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.transitions.everywhere.ArcMotion;
import android.transitions.everywhere.AutoTransition;
import android.transitions.everywhere.ChangeBounds;
import android.transitions.everywhere.ChangeClipBounds;
import android.transitions.everywhere.ChangeImageTransform;
import android.transitions.everywhere.ChangeTransform;
import android.transitions.everywhere.Explode;
import android.transitions.everywhere.Fade;
import android.transitions.everywhere.PathMotion;
import android.transitions.everywhere.PatternPathMotion;
import android.transitions.everywhere.R;
import android.transitions.everywhere.Scene;
import android.transitions.everywhere.Slide;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionManager;
import android.transitions.everywhere.TransitionSet;
import android.transitions.everywhere.hidden.ChangeScroll;
import android.transitions.everywhere.hidden.Recolor;
import android.transitions.everywhere.utils.ArrayMap;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.Xml;
import android.view.InflateException;
import android.view.ViewGroup;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransitionInflater {
    private static final ArrayMap<Context, TransitionInflater> sInflaterMap = new ArrayMap();
    private static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final ArrayMap<String, Constructor> sConstructors = new ArrayMap();
    private Context mContext;
    SparseArray<Scene> mScenes = new SparseArray();

    private TransitionInflater(Context context) {
        this.mContext = context;
    }

    public static TransitionInflater from(Context context) {
        TransitionInflater inflater = sInflaterMap.get(context);
        if (inflater != null) {
            return inflater;
        }
        inflater = new TransitionInflater(context);
        sInflaterMap.put(context, inflater);
        return inflater;
    }

    public Transition inflateTransition(int resource) {
        XmlResourceParser parser = this.mContext.getResources().getXml(resource);
        try {
            Transition transition = this.createTransitionFromXml((XmlPullParser)parser, Xml.asAttributeSet((XmlPullParser)parser), null);
            return transition;
        }
        catch (XmlPullParserException e) {
            InflateException ex = new InflateException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        finally {
            parser.close();
        }
    }

    public TransitionManager inflateTransitionManager(int resource, ViewGroup sceneRoot) {
        XmlResourceParser parser = this.mContext.getResources().getXml(resource);
        try {
            TransitionManager transitionManager = this.createTransitionManagerFromXml((XmlPullParser)parser, Xml.asAttributeSet((XmlPullParser)parser), sceneRoot);
            return transitionManager;
        }
        catch (XmlPullParserException e) {
            InflateException ex = new InflateException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        finally {
            parser.close();
        }
    }

    private Transition createTransitionFromXml(XmlPullParser parser, AttributeSet attrs, Transition parent) throws XmlPullParserException, IOException {
        int type;
        TransitionSet transitionSet;
        Transition transition = null;
        int depth = parser.getDepth();
        TransitionSet transitionSet2 = transitionSet = parent instanceof TransitionSet ? (TransitionSet)parent : null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("fade".equals(name)) {
                transition = new Fade(this.mContext, attrs);
            } else if ("changeBounds".equals(name)) {
                transition = new ChangeBounds(this.mContext, attrs);
            } else if ("slide".equals(name)) {
                transition = new Slide(this.mContext, attrs);
            } else if ("explode".equals(name)) {
                transition = new Explode(this.mContext, attrs);
            } else if ("changeImageTransform".equals(name)) {
                transition = new ChangeImageTransform(this.mContext, attrs);
            } else if ("changeTransform".equals(name)) {
                transition = new ChangeTransform(this.mContext, attrs);
            } else if ("changeClipBounds".equals(name)) {
                transition = new ChangeClipBounds(this.mContext, attrs);
            } else if ("autoTransition".equals(name)) {
                transition = new AutoTransition(this.mContext, attrs);
            } else if ("recolor".equals(name)) {
                transition = new Recolor(this.mContext, attrs);
            } else if ("changeScroll".equals(name)) {
                transition = new ChangeScroll(this.mContext, attrs);
            } else if ("transitionSet".equals(name)) {
                transition = new TransitionSet(this.mContext, attrs);
            } else if ("transition".equals(name)) {
                transition = (Transition)this.createCustom(attrs, Transition.class, "transition");
            } else if ("targets".equals(name)) {
                this.getTargetIds(parser, attrs, parent);
            } else if ("arcMotion".equals(name)) {
                parent.setPathMotion(new ArcMotion(this.mContext, attrs));
            } else if ("pathMotion".equals(name)) {
                parent.setPathMotion((PathMotion)this.createCustom(attrs, PathMotion.class, "pathMotion"));
            } else if ("patternPathMotion".equals(name)) {
                parent.setPathMotion(new PatternPathMotion(this.mContext, attrs));
            } else {
                throw new RuntimeException("Unknown scene name: " + parser.getName());
            }
            if (transition == null) continue;
            if (!parser.isEmptyElementTag()) {
                this.createTransitionFromXml(parser, attrs, transition);
            }
            if (transitionSet != null) {
                transitionSet.addTransition(transition);
                transition = null;
                continue;
            }
            if (parent == null) continue;
            throw new InflateException("Could not add transition to another transition.");
        }
        return transition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createCustom(AttributeSet attrs, Class expectedType, String tag) {
        String className = attrs.getAttributeValue(null, "class");
        if (className == null) {
            throw new InflateException(tag + " tag must have a 'class' attribute");
        }
        try {
            ArrayMap<String, Constructor> arrayMap = sConstructors;
            synchronized (arrayMap) {
                Class c;
                Constructor constructor = sConstructors.get(className);
                if (constructor == null && (c = this.mContext.getClassLoader().loadClass(className).asSubclass(expectedType)) != null) {
                    constructor = c.getConstructor(sConstructorSignature);
                    sConstructors.put(className, constructor);
                }
                return constructor.newInstance(this.mContext, attrs);
            }
        }
        catch (InstantiationException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, (Throwable)e);
        }
    }

    private void getTargetIds(XmlPullParser parser, AttributeSet attrs, Transition transition) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("target")) {
                TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionTarget);
                int id2 = a.getResourceId(R.styleable.TransitionTarget_targetId, 0);
                if (id2 != 0) {
                    transition.addTarget(id2);
                    continue;
                }
                id2 = a.getResourceId(R.styleable.TransitionTarget_excludeId, 0);
                if (id2 != 0) {
                    transition.excludeTarget(id2, true);
                    continue;
                }
                String transitionName = a.getString(R.styleable.TransitionTarget_targetName);
                if (transitionName != null) {
                    transition.addTarget(transitionName);
                    continue;
                }
                transitionName = a.getString(R.styleable.TransitionTarget_excludeName);
                if (transitionName != null) {
                    transition.excludeTarget(transitionName, true);
                    continue;
                }
                String className = a.getString(R.styleable.TransitionTarget_excludeClass);
                try {
                    Class<?> clazz;
                    if (className != null) {
                        clazz = Class.forName(className);
                        transition.excludeTarget(clazz, true);
                        continue;
                    }
                    className = a.getString(R.styleable.TransitionTarget_targetClass);
                    if (className == null) continue;
                    clazz = Class.forName(className);
                    transition.addTarget(clazz);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not create " + className, e);
                }
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
    }

    private TransitionManager createTransitionManagerFromXml(XmlPullParser parser, AttributeSet attrs, ViewGroup sceneRoot) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        TransitionManager transitionManager = null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("transitionManager")) {
                transitionManager = new TransitionManager();
                continue;
            }
            if (name.equals("transition") && transitionManager != null) {
                this.loadTransition(attrs, sceneRoot, transitionManager);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        return transitionManager;
    }

    private void loadTransition(AttributeSet attrs, ViewGroup sceneRoot, TransitionManager transitionManager) throws Resources.NotFoundException {
        Transition transition;
        Scene toScene;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionManager);
        int transitionId = a.getResourceId(R.styleable.TransitionManager_transition, -1);
        int fromId = a.getResourceId(R.styleable.TransitionManager_fromScene, -1);
        Scene fromScene = fromId < 0 ? null : Scene.getSceneForLayout(sceneRoot, fromId, this.mContext);
        int toId = a.getResourceId(R.styleable.TransitionManager_toScene, -1);
        Scene scene = toScene = toId < 0 ? null : Scene.getSceneForLayout(sceneRoot, toId, this.mContext);
        if (transitionId >= 0 && (transition = this.inflateTransition(transitionId)) != null) {
            if (toScene == null) {
                throw new RuntimeException("No toScene for transition ID " + transitionId);
            }
            if (fromScene == null) {
                transitionManager.setTransition(toScene, transition);
            } else {
                transitionManager.setTransition(fromScene, toScene, transition);
            }
        }
        a.recycle();
    }
}

