/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.os.Build;
import android.transitions.everywhere.AutoTransition;
import android.transitions.everywhere.Scene;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.utils.ArrayMap;
import android.transitions.everywhere.utils.ViewGroupOverlayUtils;
import android.transitions.everywhere.utils.ViewUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TransitionManager {
    private static String LOG_TAG = "TransitionManager";
    private static Transition sDefaultTransition = new AutoTransition();
    private static final String[] EMPTY_STRINGS = new String[0];
    ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();
    ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions = new ArrayMap();
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions = new ThreadLocal();
    private static ArrayList<ViewGroup> sPendingTransitions = new ArrayList();

    public void setDefaultTransition(Transition transition) {
        sDefaultTransition = transition;
    }

    public static Transition getDefaultTransition() {
        return sDefaultTransition;
    }

    public void setTransition(Scene scene, Transition transition) {
        this.mSceneTransitions.put(scene, transition);
    }

    public void setTransition(Scene fromScene, Scene toScene, Transition transition) {
        ArrayMap<Scene, Transition> sceneTransitionMap = this.mScenePairTransitions.get(toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put(toScene, sceneTransitionMap);
        }
        sceneTransitionMap.put(fromScene, transition);
    }

    private Transition getTransition(Scene scene) {
        ArrayMap<Scene, Transition> sceneTransitionMap;
        Scene currScene;
        Transition transition = null;
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (sceneRoot != null && (currScene = Scene.getCurrentScene((View)sceneRoot)) != null && (sceneTransitionMap = this.mScenePairTransitions.get(scene)) != null && (transition = sceneTransitionMap.get(currScene)) != null) {
            return transition;
        }
        transition = this.mSceneTransitions.get(scene);
        return transition != null ? transition : sDefaultTransition;
    }

    private static void changeScene(Scene scene, Transition transition) {
        ViewGroup sceneRoot = scene.getSceneRoot();
        Transition transitionClone = null;
        if (TransitionManager.isTransitionsAllowed()) {
            Scene oldScene;
            if (transition != null) {
                transitionClone = transition.clone();
                transitionClone.setSceneRoot(sceneRoot);
            }
            if ((oldScene = Scene.getCurrentScene((View)sceneRoot)) != null && transitionClone != null && oldScene.isCreatedFromLayoutResource()) {
                transitionClone.setCanRemoveViews(true);
            }
        }
        TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
        scene.enter();
        TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
    }

    private static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        WeakReference<ArrayMap<Object, ArrayList<Transition>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions == null || runningTransitions.get() == null) {
            ArrayMap transitions = new ArrayMap();
            runningTransitions = new WeakReference(transitions);
            sRunningTransitions.set(runningTransitions);
        }
        return (ArrayMap)runningTransitions.get();
    }

    private static void sceneChangeRunTransition(final ViewGroup sceneRoot, final Transition transition) {
        if (transition != null && TransitionManager.isTransitionsAllowed()) {
            ViewGroupOverlayUtils.initializeOverlay((View)sceneRoot);
            ViewTreeObserver observer = sceneRoot.getViewTreeObserver();
            ViewTreeObserver.OnPreDrawListener listener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    sceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    sPendingTransitions.remove(sceneRoot);
                    final ArrayMap runningTransitions = TransitionManager.getRunningTransitions();
                    ArrayList<Transition> currentTransitions = (ArrayList<Transition>)runningTransitions.get(sceneRoot);
                    ArrayList previousRunningTransitions = null;
                    if (currentTransitions == null) {
                        currentTransitions = new ArrayList<Transition>();
                        runningTransitions.put(sceneRoot, currentTransitions);
                    } else if (currentTransitions.size() > 0) {
                        previousRunningTransitions = new ArrayList(currentTransitions);
                    }
                    currentTransitions.add(transition);
                    transition.addListener(new Transition.TransitionListenerAdapter(){

                        @Override
                        public void onTransitionEnd(Transition transition) {
                            ArrayList currentTransitions = (ArrayList)runningTransitions.get(sceneRoot);
                            currentTransitions.remove(transition);
                            transition.onEndOfAllTransitions();
                        }
                    });
                    transition.captureValues(sceneRoot, false);
                    if (previousRunningTransitions != null) {
                        for (Transition runningTransition : previousRunningTransitions) {
                            runningTransition.resume((View)sceneRoot);
                        }
                    }
                    transition.playTransition(sceneRoot);
                    return true;
                }
            };
            observer.addOnPreDrawListener(listener);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, Transition transition) {
        Scene previousScene;
        if (TransitionManager.isTransitionsAllowed()) {
            ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
            if (runningTransitions != null && runningTransitions.size() > 0) {
                for (Transition runningTransition : runningTransitions) {
                    runningTransition.pause((View)sceneRoot);
                }
            }
            if (transition != null) {
                transition.captureValues(sceneRoot, true);
            }
        }
        if ((previousScene = Scene.getCurrentScene((View)sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public void transitionTo(Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    public static void go(Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(Scene scene, Transition transition) {
        TransitionManager.changeScene(scene, transition);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot) {
        TransitionManager.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, Transition transition) {
        if (!sPendingTransitions.contains(sceneRoot) && ViewUtils.isLaidOut((View)sceneRoot, true)) {
            sPendingTransitions.add(sceneRoot);
            if (transition == null) {
                transition = sDefaultTransition;
            }
            Transition transitionClone = transition.clone();
            TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
            Scene.setCurrentScene((View)sceneRoot, null);
            TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }

    public static boolean isTransitionsAllowed() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static void setTransitionName(View v, String transitionName) {
        ViewUtils.setTransitionName(v, transitionName);
    }

    public static String getTransitionName(View v) {
        return ViewUtils.getTransitionName(v);
    }
}

