/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.transitions.everywhere.R;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionUtils;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.utils.ViewGroupOverlayUtils;
import android.transitions.everywhere.utils.ViewUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=11)
public abstract class Visibility
extends Transition {
    static final String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static final String PROPNAME_PARENT = "android:visibility:parent";
    private static final String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    private static final String[] sTransitionProperties = new String[]{"android:visibility:visibility"};
    private int mMode = 3;
    private int mForcedStartVisibility = -1;
    private int mForcedEndVisibility = -1;
    private int mFinalVisibility;
    private View mFinalViewToKeep;

    public Visibility() {
    }

    public Visibility(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VisibilityTransition);
        int mode = a.getInt(R.styleable.VisibilityTransition_transitionVisibilityMode, 0);
        a.recycle();
        if (mode != 0) {
            this.setMode(mode);
        }
    }

    public void setMode(int mode) {
        if ((mode & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = mode;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    private void captureValues(TransitionValues transitionValues, int forcedVisibility) {
        int visibility = forcedVisibility != -1 ? forcedVisibility : transitionValues.view.getVisibility();
        transitionValues.values.put(PROPNAME_VISIBILITY, visibility);
        transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put(PROPNAME_SCREEN_LOCATION, loc);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedStartVisibility);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedEndVisibility);
    }

    @Override
    public void forceVisibility(int visibility, boolean isStartValue) {
        if (isStartValue) {
            this.mForcedStartVisibility = visibility;
        } else {
            this.mForcedEndVisibility = visibility;
        }
    }

    public boolean isVisible(TransitionValues values) {
        if (values == null) {
            return false;
        }
        int visibility = (Integer)values.values.get(PROPNAME_VISIBILITY);
        View parent = (View)values.values.get(PROPNAME_PARENT);
        return visibility == 0 && parent != null;
    }

    private VisibilityInfo getVisibilityChangeInfo(TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = new VisibilityInfo();
        visInfo.visibilityChange = false;
        visInfo.fadeIn = false;
        if (startValues != null && startValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.startVisibility = (Integer)startValues.values.get(PROPNAME_VISIBILITY);
            visInfo.startParent = (ViewGroup)startValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.startVisibility = -1;
            visInfo.startParent = null;
        }
        if (endValues != null && endValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.endVisibility = (Integer)endValues.values.get(PROPNAME_VISIBILITY);
            visInfo.endParent = (ViewGroup)endValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.endVisibility = -1;
            visInfo.endParent = null;
        }
        if (startValues != null && endValues != null) {
            if (visInfo.startVisibility == visInfo.endVisibility && visInfo.startParent == visInfo.endParent) {
                return visInfo;
            }
            if (visInfo.startVisibility != visInfo.endVisibility) {
                if (visInfo.startVisibility == 0) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.endVisibility == 0) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            } else if (visInfo.startParent != visInfo.endParent) {
                if (visInfo.endParent == null) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.startParent == null) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            }
        } else if (startValues == null && visInfo.endVisibility == 0) {
            visInfo.fadeIn = true;
            visInfo.visibilityChange = true;
        } else if (endValues == null && visInfo.startVisibility == 0) {
            visInfo.fadeIn = false;
            visInfo.visibilityChange = true;
        }
        return visInfo;
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = this.getVisibilityChangeInfo(startValues, endValues);
        if (visInfo.visibilityChange && (visInfo.startParent != null || visInfo.endParent != null)) {
            if (visInfo.fadeIn) {
                return this.onAppear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
            }
            return this.onDisappear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
        }
        return null;
    }

    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 1) != 1 || endValues == null) {
            return null;
        }
        if (startValues == null) {
            VisibilityInfo parentVisibilityInfo = null;
            View endParent = (View)endValues.view.getParent();
            TransitionValues startParentValues = this.getMatchedTransitionValues(endParent, false);
            TransitionValues endParentValues = this.getTransitionValues(endParent, false);
            parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
            if (parentVisibilityInfo.visibilityChange) {
                return null;
            }
        }
        return this.onAppear(sceneRoot, endValues.view, startValues, endValues);
    }

    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    public Animator onDisappear(final ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 2) != 2) {
            return null;
        }
        View startView = startValues != null ? startValues.view : null;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                overlayView = endView;
            } else if (startView != null) {
                if (startView.getParent() == null) {
                    overlayView = startView;
                } else if (startView.getParent() instanceof View) {
                    int id2;
                    View startParent = (View)startView.getParent();
                    TransitionValues startParentValues = this.getTransitionValues(startParent, true);
                    TransitionValues endParentValues = this.getMatchedTransitionValues(startParent, true);
                    VisibilityInfo parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
                    if (!parentVisibilityInfo.visibilityChange) {
                        overlayView = TransitionUtils.copyViewImage(sceneRoot, startView, startParent);
                    } else if (startParent.getParent() == null && (id2 = startParent.getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                        overlayView = startView;
                    }
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = endView;
        } else if (startView == endView) {
            viewToKeep = endView;
        } else {
            overlayView = startView;
        }
        final int finalVisibility = endVisibility;
        if (overlayView != null) {
            int[] screenLoc = (int[])startValues.values.get(PROPNAME_SCREEN_LOCATION);
            ViewGroupOverlayUtils.addOverlay(sceneRoot, overlayView, screenLoc[0], screenLoc[1]);
            Animator animator = this.onDisappear(sceneRoot, overlayView, startValues, endValues);
            if (animator == null) {
                ViewGroupOverlayUtils.removeOverlay(sceneRoot, overlayView);
            } else {
                final View finalOverlayView = overlayView;
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ViewGroupOverlayUtils.removeOverlay(sceneRoot, finalOverlayView);
                    }
                });
            }
            return animator;
        }
        if (viewToKeep != null) {
            Animator animator;
            boolean isForcedVisibility;
            int originalVisibility = -1;
            boolean bl = isForcedVisibility = this.mForcedStartVisibility != -1 || this.mForcedEndVisibility != -1;
            if (!isForcedVisibility) {
                originalVisibility = viewToKeep.getVisibility();
                viewToKeep.setVisibility(0);
            }
            if ((animator = this.onDisappear(sceneRoot, viewToKeep, startValues, endValues)) != null) {
                final View finalViewToKeep = viewToKeep;
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                    boolean mCanceled = false;

                    public void onAnimationPause(Animator animation) {
                        if (!this.mCanceled && !isForcedVisibility) {
                            finalViewToKeep.setVisibility(finalVisibility);
                        }
                    }

                    public void onAnimationResume(Animator animation) {
                        if (!this.mCanceled && !isForcedVisibility) {
                            finalViewToKeep.setVisibility(0);
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                        this.mCanceled = true;
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (!this.mCanceled) {
                            if (!isForcedVisibility) {
                                Visibility.this.mFinalViewToKeep = finalViewToKeep;
                                Visibility.this.mFinalVisibility = finalVisibility;
                            }
                            ViewUtils.setTransitionAlpha(finalViewToKeep, 0.0f);
                        }
                    }
                });
            } else if (!isForcedVisibility) {
                viewToKeep.setVisibility(originalVisibility);
            }
            return animator;
        }
        return null;
    }

    @Override
    void onEndOfAllTransitions() {
        if (this.mFinalViewToKeep != null) {
            this.mFinalViewToKeep.setVisibility(this.mFinalVisibility);
            this.mFinalViewToKeep = null;
        }
    }

    @Override
    boolean areValuesChanged(TransitionValues oldValues, TransitionValues newValues) {
        VisibilityInfo changeInfo = this.getVisibilityChangeInfo(oldValues, newValues);
        if (oldValues == null && newValues == null) {
            return false;
        }
        return changeInfo.visibilityChange && (changeInfo.startVisibility == 0 || changeInfo.endVisibility == 0);
    }

    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    private static class VisibilityInfo {
        boolean visibilityChange;
        boolean fadeIn;
        int startVisibility;
        int endVisibility;
        ViewGroup startParent;
        ViewGroup endParent;

        private VisibilityInfo() {
        }
    }
}

