/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.hidden;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionUtils;
import android.transitions.everywhere.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=14)
public class ChangeScroll
extends Transition {
    private static final String PROPNAME_SCROLL_X = "android:changeScroll:x";
    private static final String PROPNAME_SCROLL_Y = "android:changeScroll:y";

    public ChangeScroll() {
    }

    public ChangeScroll(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private void captureValues(TransitionValues transitionValues) {
        transitionValues.values.put(PROPNAME_SCROLL_X, transitionValues.view.getScrollX());
        transitionValues.values.put(PROPNAME_SCROLL_Y, transitionValues.view.getScrollY());
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null || Build.VERSION.SDK_INT < 14) {
            return null;
        }
        View view = endValues.view;
        int startX = (Integer)startValues.values.get(PROPNAME_SCROLL_X);
        int endX = (Integer)endValues.values.get(PROPNAME_SCROLL_X);
        int startY = (Integer)startValues.values.get(PROPNAME_SCROLL_Y);
        int endY = (Integer)endValues.values.get(PROPNAME_SCROLL_Y);
        ObjectAnimator scrollXAnimator = null;
        ObjectAnimator scrollYAnimator = null;
        if (startX != endX) {
            view.setScrollX(startX);
            scrollXAnimator = ObjectAnimator.ofInt((Object)view, (String)"scrollX", (int[])new int[]{startX, endX});
        }
        if (startY != endY) {
            view.setScrollY(startY);
            scrollYAnimator = ObjectAnimator.ofInt((Object)view, (String)"scrollY", (int[])new int[]{startY, endY});
        }
        return TransitionUtils.mergeAnimators(scrollXAnimator, scrollYAnimator);
    }
}

