/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.hidden;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionValues;
import android.transitions.everywhere.utils.RectEvaluator;
import android.transitions.everywhere.utils.ViewGroupOverlayUtils;
import android.util.Property;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

@TargetApi(value=14)
public class Crossfade
extends Transition {
    private static final String LOG_TAG = "Crossfade";
    private static final String PROPNAME_BITMAP = "android:crossfade:bitmap";
    private static final String PROPNAME_DRAWABLE = "android:crossfade:drawable";
    private static final String PROPNAME_BOUNDS = "android:crossfade:bounds";
    private static RectEvaluator sRectEvaluator;
    private int mFadeBehavior = 1;
    private int mResizeBehavior = 1;
    public static final int FADE_BEHAVIOR_CROSSFADE = 0;
    public static final int FADE_BEHAVIOR_REVEAL = 1;
    public static final int FADE_BEHAVIOR_OUT_IN = 2;
    public static final int RESIZE_BEHAVIOR_NONE = 0;
    public static final int RESIZE_BEHAVIOR_SCALE = 1;

    public Crossfade setFadeBehavior(int fadeBehavior) {
        if (fadeBehavior >= 0 && fadeBehavior <= 2) {
            this.mFadeBehavior = fadeBehavior;
        }
        return this;
    }

    public int getFadeBehavior() {
        return this.mFadeBehavior;
    }

    public Crossfade setResizeBehavior(int resizeBehavior) {
        if (resizeBehavior >= 0 && resizeBehavior <= 1) {
            this.mResizeBehavior = resizeBehavior;
        }
        return this;
    }

    public int getResizeBehavior() {
        return this.mResizeBehavior;
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null || Build.VERSION.SDK_INT < 14) {
            return null;
        }
        if (sRectEvaluator == null) {
            sRectEvaluator = new RectEvaluator();
        }
        final boolean useParentOverlay = this.mFadeBehavior != 1;
        final View view = endValues.view;
        Map<String, Object> startVals = startValues.values;
        Map<String, Object> endVals = endValues.values;
        Rect startBounds = (Rect)startVals.get(PROPNAME_BOUNDS);
        Rect endBounds = (Rect)endVals.get(PROPNAME_BOUNDS);
        Bitmap startBitmap = (Bitmap)startVals.get(PROPNAME_BITMAP);
        Bitmap endBitmap = (Bitmap)endVals.get(PROPNAME_BITMAP);
        final BitmapDrawable startDrawable = (BitmapDrawable)startVals.get(PROPNAME_DRAWABLE);
        final BitmapDrawable endDrawable = (BitmapDrawable)endVals.get(PROPNAME_DRAWABLE);
        if (startDrawable != null && endDrawable != null && !startBitmap.sameAs(endBitmap)) {
            ViewGroupOverlayUtils.addCrossfadeOverlay(useParentOverlay, view, this.mFadeBehavior, startDrawable, endDrawable);
            ObjectAnimator anim = this.mFadeBehavior == 2 ? ObjectAnimator.ofInt((Object)startDrawable, (String)"alpha", (int[])new int[]{255, 0, 0}) : ObjectAnimator.ofInt((Object)startDrawable, (String)"alpha", (int[])new int[]{0});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    view.invalidate(startDrawable.getBounds());
                }
            });
            ObjectAnimator anim1 = null;
            if (this.mFadeBehavior == 2) {
                anim1 = ObjectAnimator.ofFloat((Object)view, (Property)View.ALPHA, (float[])new float[]{0.0f, 0.0f, 1.0f});
            } else if (this.mFadeBehavior == 0) {
                anim1 = ObjectAnimator.ofFloat((Object)view, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
            }
            anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ViewGroupOverlayUtils.removeCrossfadeOverlay(useParentOverlay, view, Crossfade.this.mFadeBehavior, startDrawable, endDrawable);
                }
            });
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{anim});
            if (anim1 != null) {
                set.playTogether(new Animator[]{anim1});
            }
            if (this.mResizeBehavior == 1 && !startBounds.equals((Object)endBounds)) {
                ObjectAnimator anim2 = ObjectAnimator.ofObject((Object)startDrawable, (String)"bounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{startBounds, endBounds});
                set.playTogether(new Animator[]{anim2});
                if (this.mResizeBehavior == 1) {
                    ObjectAnimator anim3 = ObjectAnimator.ofObject((Object)endDrawable, (String)"bounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{startBounds, endBounds});
                    set.playTogether(new Animator[]{anim3});
                }
            }
            return set;
        }
        return null;
    }

    private void captureValues(TransitionValues transitionValues) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        View view = transitionValues.view;
        Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
        if (this.mFadeBehavior != 1) {
            bounds.offset(view.getLeft(), view.getTop());
        }
        transitionValues.values.put(PROPNAME_BOUNDS, bounds);
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (view instanceof TextureView) {
            bitmap = ((TextureView)view).getBitmap();
        } else {
            Canvas c = new Canvas(bitmap);
            view.draw(c);
        }
        transitionValues.values.put(PROPNAME_BITMAP, bitmap);
        BitmapDrawable drawable = new BitmapDrawable(view.getResources(), bitmap);
        drawable.setBounds(bounds);
        transitionValues.values.put(PROPNAME_DRAWABLE, drawable);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }
}

