/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.graphics.Path;
import android.graphics.PointF;
import android.os.Build;
import android.transitions.everywhere.Transition;
import android.transitions.everywhere.TransitionUtils;
import android.transitions.everywhere.utils.PropertyCompatObject;
import android.util.Property;
import android.view.View;

public class AnimatorUtils {
    private static final AnimatorCompatImpl IMPL;

    public static void addPauseListener(Animator animator, Animator.AnimatorPauseListener listener) {
        IMPL.addPauseListener(animator, listener);
    }

    public static void pause(Animator animator) {
        IMPL.pause(animator);
    }

    public static void resume(Animator animator) {
        IMPL.resume(animator);
    }

    public static ObjectAnimator ofInt(Transition transition, Object target, String xPropertyName, String yPropertyName, int startLeft, int startTop, int endLeft, int endTop) {
        if (startLeft != endLeft || startTop != endTop) {
            return IMPL.ofInt(transition, target, xPropertyName, yPropertyName, startLeft, startTop, endLeft, endTop);
        }
        return null;
    }

    public static ObjectAnimator ofFloat(Transition transition, Object target, String xPropertyName, String yPropertyName, float startLeft, float startTop, float endLeft, float endTop) {
        if (startLeft != endLeft || startTop != endTop) {
            return IMPL.ofFloat(transition, target, xPropertyName, yPropertyName, startLeft, startTop, endLeft, endTop);
        }
        return null;
    }

    public static Animator ofInt(Transition transition, Object target, Property propertyX, Property propertyY, int startX, int startY, int endX, int endY) {
        if (startX != endX || startY != endY) {
            return IMPL.ofInt(transition, target, propertyX, propertyY, startX, startY, endX, endY);
        }
        return null;
    }

    public static <V> PropertyValuesHolder pvhOfObject(Property<?, V> property, TypeConverter<PointF, V> converter, Path path) {
        return IMPL.pvhOfObject(property, converter, path);
    }

    public static boolean isAnimatorStarted(Animator anim) {
        return IMPL.isAnimatorStarted(anim);
    }

    public static boolean hasOverlappingRendering(View view) {
        return IMPL.hasOverlappingRendering(view);
    }

    @TargetApi(value=11)
    public static ObjectAnimator ofObject(PropertyCompatObject objectCompat, TypeEvaluator evaluator, Object ... values) {
        return ObjectAnimator.ofObject((Object)objectCompat, (String)objectCompat.getProperty(), (TypeEvaluator)evaluator, (Object[])values);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new LollipopAnimatorCompatImpl() : (version >= 19 ? new KitKatAnimatorCompatImpl() : (version >= 16 ? new JellyBeanCompatImpl() : (version >= 14 ? new IceCreamSandwichAnimatorCompatImpl() : (version >= 11 ? new HoneyCombAnimatorCompatImpl() : new BaseAnimatorCompatImpl()))));
    }

    @TargetApi(value=21)
    static class LollipopAnimatorCompatImpl
    extends KitKatAnimatorCompatImpl {
        LollipopAnimatorCompatImpl() {
        }

        @Override
        public ObjectAnimator ofInt(Transition transition, Object target, String xPropertyName, String yPropertyName, int startLeft, int startTop, int endLeft, int endTop) {
            return ObjectAnimator.ofInt((Object)target, (String)xPropertyName, (String)yPropertyName, (Path)transition.getPathMotion().getPath(startLeft, startTop, endLeft, endTop));
        }

        @Override
        public ObjectAnimator ofFloat(Transition transition, Object target, String xPropertyName, String yPropertyName, float startLeft, float startTop, float endLeft, float endTop) {
            Path path;
            if (transition == null) {
                path = new Path();
                path.moveTo(startLeft, startTop);
                path.lineTo(endLeft, endTop);
            } else {
                path = transition.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
            }
            return ObjectAnimator.ofFloat((Object)target, (String)xPropertyName, (String)yPropertyName, (Path)path);
        }

        @Override
        public Animator ofInt(Transition transition, Object target, Property propertyX, Property propertyY, int startX, int startY, int endX, int endY) {
            Path positionPath = transition.getPathMotion().getPath(startX, startY, endX, endY);
            return ObjectAnimator.ofInt((Object)target, (Property)propertyX, (Property)propertyY, (Path)positionPath);
        }

        @Override
        public <V> PropertyValuesHolder pvhOfObject(Property<?, V> property, TypeConverter<PointF, V> converter, Path path) {
            return PropertyValuesHolder.ofObject(property, converter, (Path)path);
        }
    }

    @TargetApi(value=19)
    static class KitKatAnimatorCompatImpl
    extends JellyBeanCompatImpl {
        KitKatAnimatorCompatImpl() {
        }

        @Override
        public void addPauseListener(Animator animator, Animator.AnimatorPauseListener listener) {
            animator.addPauseListener(listener);
        }

        @Override
        public void pause(Animator animator) {
            animator.pause();
        }

        @Override
        public void resume(Animator animator) {
            animator.resume();
        }
    }

    @TargetApi(value=16)
    static class JellyBeanCompatImpl
    extends IceCreamSandwichAnimatorCompatImpl {
        JellyBeanCompatImpl() {
        }

        @Override
        public boolean hasOverlappingRendering(View view) {
            return view.hasOverlappingRendering();
        }
    }

    @TargetApi(value=14)
    static class IceCreamSandwichAnimatorCompatImpl
    extends HoneyCombAnimatorCompatImpl {
        IceCreamSandwichAnimatorCompatImpl() {
        }

        @Override
        public Animator ofInt(Transition transition, Object target, Property propertyX, Property propertyY, int startX, int startY, int endX, int endY) {
            ObjectAnimator animX = startX == endX ? null : ObjectAnimator.ofInt((Object)target, (Property)propertyX, (int[])new int[]{startX, endX});
            ObjectAnimator animY = startY == endY ? null : ObjectAnimator.ofInt((Object)target, (Property)propertyY, (int[])new int[]{startY, endY});
            return TransitionUtils.mergeAnimators(animX, animY);
        }

        @Override
        public boolean isAnimatorStarted(Animator anim) {
            return anim.isStarted();
        }
    }

    @TargetApi(value=11)
    static class HoneyCombAnimatorCompatImpl
    extends BaseAnimatorCompatImpl {
        HoneyCombAnimatorCompatImpl() {
        }

        @Override
        public void pause(Animator animator) {
            animator.cancel();
        }

        @Override
        public ObjectAnimator ofInt(Transition transition, Object target, String xPropertyName, String yPropertyName, int startLeft, int startTop, int endLeft, int endTop) {
            int pvhNumber = 0;
            if (startLeft != endLeft) {
                ++pvhNumber;
            }
            if (startTop != endTop) {
                ++pvhNumber;
            }
            int pvhIndex = 0;
            PropertyValuesHolder[] pvh = new PropertyValuesHolder[pvhNumber];
            if (startLeft != endLeft) {
                pvh[pvhIndex++] = PropertyValuesHolder.ofInt((String)xPropertyName, (int[])new int[]{startLeft, endLeft});
            }
            if (startTop != endTop) {
                pvh[pvhIndex] = PropertyValuesHolder.ofInt((String)yPropertyName, (int[])new int[]{startTop, endTop});
            }
            return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])pvh);
        }

        @Override
        public ObjectAnimator ofFloat(Transition transition, Object target, String xPropertyName, String yPropertyName, float startLeft, float startTop, float endLeft, float endTop) {
            int pvhNumber = 0;
            if (startLeft != endLeft) {
                ++pvhNumber;
            }
            if (startTop != endTop) {
                ++pvhNumber;
            }
            int pvhIndex = 0;
            PropertyValuesHolder[] pvh = new PropertyValuesHolder[pvhNumber];
            if (startLeft != endLeft) {
                pvh[pvhIndex++] = PropertyValuesHolder.ofFloat((String)xPropertyName, (float[])new float[]{startLeft, endLeft});
            }
            if (startTop != endTop) {
                pvh[pvhIndex++] = PropertyValuesHolder.ofFloat((String)yPropertyName, (float[])new float[]{startTop, endTop});
            }
            return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])pvh);
        }
    }

    static class BaseAnimatorCompatImpl
    implements AnimatorCompatImpl {
        BaseAnimatorCompatImpl() {
        }

        @Override
        public void addPauseListener(Animator animator, Animator.AnimatorPauseListener listener) {
        }

        @Override
        public void pause(Animator animator) {
        }

        @Override
        public void resume(Animator animator) {
        }

        @Override
        public ObjectAnimator ofInt(Transition transition, Object target, String xPropertyName, String yPropertyName, int startLeft, int startTop, int endLeft, int endTop) {
            return null;
        }

        @Override
        public ObjectAnimator ofFloat(Transition transition, Object target, String xPropertyName, String yPropertyName, float startLeft, float startTop, float endLeft, float endTop) {
            return null;
        }

        @Override
        public Animator ofInt(Transition transition, Object target, Property propertyX, Property propertyY, int startX, int startY, int endX, int endY) {
            return null;
        }

        @Override
        public <V> PropertyValuesHolder pvhOfObject(Property<?, V> property, TypeConverter<PointF, V> converter, Path path) {
            return null;
        }

        @Override
        public boolean isAnimatorStarted(Animator anim) {
            return false;
        }

        @Override
        public boolean hasOverlappingRendering(View view) {
            return false;
        }
    }

    static interface AnimatorCompatImpl {
        public void addPauseListener(Animator var1, Animator.AnimatorPauseListener var2);

        public void pause(Animator var1);

        public void resume(Animator var1);

        public ObjectAnimator ofInt(Transition var1, Object var2, String var3, String var4, int var5, int var6, int var7, int var8);

        public ObjectAnimator ofFloat(Transition var1, Object var2, String var3, String var4, float var5, float var6, float var7, float var8);

        public Animator ofInt(Transition var1, Object var2, Property var3, Property var4, int var5, int var6, int var7, int var8);

        public <V> PropertyValuesHolder pvhOfObject(Property<?, V> var1, TypeConverter<PointF, V> var2, Path var3);

        public boolean isAnimatorStarted(Animator var1);

        public boolean hasOverlappingRendering(View var1);
    }
}

