/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static final String TAG = ReflectionUtils.class.getSimpleName();

    private ReflectionUtils() {
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> targetClass, String name, Class<?> ... parameterTypes) {
        if (targetClass == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        try {
            return targetClass.getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Object invoke(Object receiver, Object defaultValue, Method method, Object ... args) {
        if (method == null) {
            return defaultValue;
        }
        try {
            return method.invoke(receiver, args);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception in invoke", (Throwable)e);
            return defaultValue;
        }
    }

    public static Field getPrivateField(Class<?> targetClass, String name) {
        if (targetClass == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        try {
            Field field = targetClass.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setFieldValue(Object receiver, Field field, Object value) {
        if (field == null) {
            return;
        }
        try {
            field.set(receiver, value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception in setFieldValue", (Throwable)e);
        }
    }
}

