/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.annotation.TargetApi;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.transitions.everywhere.utils.ViewOverlayPreJellybean;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOverlay;

public class ViewGroupOverlayUtils {
    private static final ViewGroupOverlayUtilsImpl IMPL = Build.VERSION.SDK_INT >= 18 ? new JellyBeanMR2ViewGroupUtilsImpl() : new BaseViewGroupOverlayUtilsImpl();

    public static void addOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
        if (overlayView != null) {
            IMPL.addOverlay(sceneRoot, overlayView, screenX, screenY);
        }
    }

    public static void initializeOverlay(View sceneRoot) {
        IMPL.initializeOverlay(sceneRoot);
    }

    public static void removeOverlay(ViewGroup sceneRoot, View overlayView) {
        if (overlayView != null) {
            IMPL.removeOverlay(sceneRoot, overlayView);
        }
    }

    public static void moveViewInOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
        if (overlayView != null) {
            IMPL.moveViewInOverlay(sceneRoot, overlayView, screenX, screenY);
        }
    }

    public static int[] getLocationOnScreenOfOverlayView(ViewGroup sceneRoot, View overlayView) {
        if (overlayView != null) {
            return IMPL.getLocationOnScreenOfOverlayView(sceneRoot, overlayView);
        }
        return new int[2];
    }

    public static void addCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
        IMPL.addCrossfadeOverlay(useParentOverlay, view, fadeBehavior, startDrawable, endDrawable);
    }

    public static void removeCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
        IMPL.removeCrossfadeOverlay(useParentOverlay, view, fadeBehavior, startDrawable, endDrawable);
    }

    @TargetApi(value=18)
    static class JellyBeanMR2ViewGroupUtilsImpl
    implements ViewGroupOverlayUtilsImpl {
        JellyBeanMR2ViewGroupUtilsImpl() {
        }

        @Override
        public void addOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
            this.moveViewInOverlay(sceneRoot, overlayView, screenX, screenY);
            sceneRoot.getOverlay().add(overlayView);
        }

        @Override
        public void removeOverlay(ViewGroup sceneRoot, View overlayView) {
            sceneRoot.getOverlay().remove(overlayView);
        }

        @Override
        public void moveViewInOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
            if (screenX != 0 && screenY != 0) {
                int[] loc = new int[2];
                sceneRoot.getLocationOnScreen(loc);
                overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
                overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
            }
        }

        @Override
        public void initializeOverlay(View sceneRoot) {
        }

        @Override
        public void addCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
            ViewOverlay overlay = JellyBeanMR2ViewGroupUtilsImpl.getViewOverlay(useParentOverlay, view);
            overlay.remove((Drawable)startDrawable);
            if (fadeBehavior == 1) {
                overlay.remove((Drawable)endDrawable);
            }
        }

        @Override
        public int[] getLocationOnScreenOfOverlayView(ViewGroup sceneRoot, View overlayView) {
            int[] location = new int[2];
            sceneRoot.getLocationOnScreen(location);
            location[0] = location[0] + overlayView.getLeft();
            location[1] = location[1] + overlayView.getTop();
            return location;
        }

        @Override
        public void removeCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
            ViewOverlay overlay = JellyBeanMR2ViewGroupUtilsImpl.getViewOverlay(useParentOverlay, view);
            if (fadeBehavior == 1) {
                overlay.add((Drawable)endDrawable);
            }
            overlay.add((Drawable)startDrawable);
        }

        private static ViewOverlay getViewOverlay(boolean useParentOverlay, View view) {
            return useParentOverlay ? ((ViewGroup)view.getParent()).getOverlay() : view.getOverlay();
        }
    }

    static class BaseViewGroupOverlayUtilsImpl
    implements ViewGroupOverlayUtilsImpl {
        BaseViewGroupOverlayUtilsImpl() {
        }

        @Override
        public void addOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
            ViewOverlayPreJellybean viewOverlay = ViewOverlayPreJellybean.getOverlay((View)sceneRoot);
            viewOverlay.addView(overlayView, screenX, screenY);
        }

        @Override
        public void removeOverlay(ViewGroup sceneRoot, View overlayView) {
            ViewOverlayPreJellybean viewOverlay = ViewOverlayPreJellybean.getOverlay((View)sceneRoot);
            viewOverlay.removeView(overlayView);
        }

        @Override
        public void moveViewInOverlay(ViewGroup sceneRoot, View overlayView, int screenX, int screenY) {
            ViewOverlayPreJellybean viewOverlay = ViewOverlayPreJellybean.getOverlay((View)sceneRoot);
            viewOverlay.moveView(overlayView, screenX, screenY);
        }

        @Override
        public void initializeOverlay(View sceneRoot) {
            ViewOverlayPreJellybean.getOverlay(sceneRoot);
        }

        @Override
        public int[] getLocationOnScreenOfOverlayView(ViewGroup sceneRoot, View overlayView) {
            int[] location = new int[2];
            overlayView.getLocationOnScreen(location);
            return location;
        }

        @Override
        public void addCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
        }

        @Override
        public void removeCrossfadeOverlay(boolean useParentOverlay, View view, int fadeBehavior, BitmapDrawable startDrawable, BitmapDrawable endDrawable) {
        }
    }

    static interface ViewGroupOverlayUtilsImpl {
        public void addOverlay(ViewGroup var1, View var2, int var3, int var4);

        public void removeOverlay(ViewGroup var1, View var2);

        public void moveViewInOverlay(ViewGroup var1, View var2, int var3, int var4);

        public void initializeOverlay(View var1);

        public int[] getLocationOnScreenOfOverlayView(ViewGroup var1, View var2);

        public void addCrossfadeOverlay(boolean var1, View var2, int var3, BitmapDrawable var4, BitmapDrawable var5);

        public void removeCrossfadeOverlay(boolean var1, View var2, int var3, BitmapDrawable var4, BitmapDrawable var5);
    }
}

