/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
class ViewOverlayPreJellybean
extends FrameLayout {
    private List<Drawable> mDrawableOverlays;

    public ViewOverlayPreJellybean(Context context) {
        super(context);
        this.init();
    }

    public ViewOverlayPreJellybean(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ViewOverlayPreJellybean(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mDrawableOverlays = new ArrayList<Drawable>();
    }

    public void addView(View view, int left, int top) {
        this.addView(view, (ViewGroup.LayoutParams)this.initParams(view, left, top));
        this.invalidate();
    }

    public void moveView(View view, int left, int top) {
        if (view.getParent() == this) {
            view.setLayoutParams((ViewGroup.LayoutParams)this.initParams(view, left, top));
        }
    }

    private FrameLayout.LayoutParams initParams(View view, int left, int top) {
        int[] loc = new int[2];
        this.getLocationOnScreen(loc);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = left -= loc[0];
        layoutParams.topMargin = top -= loc[1];
        view.setLeft(left);
        view.setTop(top);
        if (view.getMeasuredWidth() != 0) {
            layoutParams.width = view.getMeasuredWidth();
            view.setRight(left + layoutParams.width);
        }
        if (view.getMeasuredHeight() != 0) {
            layoutParams.height = view.getMeasuredHeight();
            view.setBottom(top + layoutParams.height);
        }
        return layoutParams;
    }

    public synchronized void addDrawable(Drawable drawable) {
        this.mDrawableOverlays.add(drawable);
        this.invalidate();
    }

    public synchronized void removeDrawable(Drawable drawable) {
        this.mDrawableOverlays.remove(drawable);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Drawable drawable : this.mDrawableOverlays) {
            drawable.draw(canvas);
        }
    }

    public static ViewOverlayPreJellybean getOverlay(View sceneRoot) {
        View group;
        for (group = sceneRoot; group != null && group.getId() != 0x1020002; group = (View)group.getParent()) {
        }
        ViewOverlayPreJellybean viewOverlayPreJellybean = null;
        if (group != null) {
            for (int i = 0; i < ((FrameLayout)group).getChildCount(); ++i) {
                View childAt = ((FrameLayout)group).getChildAt(i);
                if (!(childAt instanceof ViewOverlayPreJellybean)) continue;
                viewOverlayPreJellybean = (ViewOverlayPreJellybean)childAt;
                break;
            }
            if (viewOverlayPreJellybean == null) {
                viewOverlayPreJellybean = new ViewOverlayPreJellybean(sceneRoot.getContext());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                params.gravity = 119;
                ((FrameLayout)group).addView((View)viewOverlayPreJellybean, (ViewGroup.LayoutParams)params);
            }
        }
        return viewOverlayPreJellybean;
    }
}

