/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.transitions.everywhere.utils.ViewOverlayPreJellybean;
import android.view.View;
import android.view.ViewGroup;

public class ViewOverlayUtils {
    private static final ViewOverlayUtilsImpl IMPL = Build.VERSION.SDK_INT >= 18 ? new JellyBeanMR2ViewUtilsImpl() : new BaseViewOverlayUtilsImpl();

    public static void addOverlay(ViewGroup sceneRoot, Drawable drawable) {
        IMPL.addOverlay(sceneRoot, drawable);
    }

    public static void removeOverlay(ViewGroup sceneRoot, Drawable drawable) {
        IMPL.removeOverlay(sceneRoot, drawable);
    }

    @TargetApi(value=18)
    static class JellyBeanMR2ViewUtilsImpl
    implements ViewOverlayUtilsImpl {
        JellyBeanMR2ViewUtilsImpl() {
        }

        @Override
        public void addOverlay(ViewGroup sceneRoot, Drawable drawable) {
            sceneRoot.getOverlay().add(drawable);
        }

        @Override
        public void removeOverlay(ViewGroup sceneRoot, Drawable drawable) {
            sceneRoot.getOverlay().remove(drawable);
        }
    }

    static class BaseViewOverlayUtilsImpl
    implements ViewOverlayUtilsImpl {
        BaseViewOverlayUtilsImpl() {
        }

        @Override
        public void addOverlay(ViewGroup sceneRoot, Drawable drawable) {
            ViewOverlayPreJellybean viewOverlay = ViewOverlayPreJellybean.getOverlay((View)sceneRoot);
            viewOverlay.addDrawable(drawable);
        }

        @Override
        public void removeOverlay(ViewGroup sceneRoot, Drawable drawable) {
            ViewOverlayPreJellybean viewOverlay = ViewOverlayPreJellybean.getOverlay((View)sceneRoot);
            viewOverlay.removeDrawable(drawable);
        }
    }

    static interface ViewOverlayUtilsImpl {
        public void addOverlay(ViewGroup var1, Drawable var2);

        public void removeOverlay(ViewGroup var1, Drawable var2);
    }
}

