/*
 * Decompiled with CFR 0.152.
 */
package android.transitions.everywhere.utils;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.transitions.everywhere.R;
import android.transitions.everywhere.utils.ViewUtilsKitKat;
import android.transitions.everywhere.utils.ViewUtilsLolipop;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=11)
public class ViewUtils {
    private static final ViewUtilsImpl IMPL;

    public static float getTransitionAlpha(View v) {
        return IMPL.getTransitionAlpha(v);
    }

    public static boolean isLaidOut(View v, boolean defaultValue) {
        return IMPL.isLaidOut(v, defaultValue);
    }

    public static void setClipBounds(View v, Rect clipBounds) {
        IMPL.setClipBounds(v, clipBounds);
    }

    public static Rect getClipBounds(View v) {
        return IMPL.getClipBounds(v);
    }

    public static void setTransitionAlpha(View v, float alpha) {
        IMPL.setTransitionAlpha(v, alpha);
    }

    public static String getAlphaProperty() {
        return IMPL.getAlphaProperty();
    }

    public static void setTransitionName(View v, String name) {
        IMPL.setTransitionName(v, name);
    }

    public static String getTransitionName(View v) {
        return IMPL.getTransitionName(v);
    }

    public static float getTranslationZ(View view) {
        return IMPL.getTranslationZ(view);
    }

    public static void setTranslationZ(View view, float z) {
        IMPL.setTranslationZ(view, z);
    }

    public static void transformMatrixToGlobal(View view, Matrix matrix) {
        IMPL.transformMatrixToGlobal(view, matrix);
    }

    public static void transformMatrixToLocal(View view, Matrix matrix) {
        IMPL.transformMatrixToLocal(view, matrix);
    }

    public static void setAnimationMatrix(View view, Matrix matrix) {
        IMPL.setAnimationMatrix(view, matrix);
    }

    public static View addGhostView(View view, ViewGroup viewGroup, Matrix matrix) {
        return IMPL.addGhostView(view, viewGroup, matrix);
    }

    public static void removeGhostView(View view) {
        IMPL.removeGhostView(view);
    }

    public static Object getWindowId(View view) {
        return IMPL.getWindowId(view);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new ViewUtilsLolipop() : (version >= 19 ? new ViewUtilsKitKat() : (version >= 18 ? new ViewUtilsJellyBeanMR2() : new BaseViewUtilsImpl()));
    }

    @TargetApi(value=18)
    static class ViewUtilsJellyBeanMR2
    extends BaseViewUtilsImpl {
        ViewUtilsJellyBeanMR2() {
        }

        @Override
        public void setClipBounds(View v, Rect clipBounds) {
            v.setClipBounds(clipBounds);
        }

        @Override
        public Rect getClipBounds(View v) {
            return v.getClipBounds();
        }

        @Override
        public Object getWindowId(View view) {
            return view.getWindowId();
        }
    }

    static class BaseViewUtilsImpl
    implements ViewUtilsImpl {
        BaseViewUtilsImpl() {
        }

        @Override
        public float getTransitionAlpha(View v) {
            return v.getAlpha();
        }

        @Override
        public boolean isLaidOut(View v, boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public void setClipBounds(View v, Rect clipBounds) {
        }

        @Override
        public Rect getClipBounds(View v) {
            return null;
        }

        @Override
        public void setTransitionName(View v, String name) {
            v.setTag(R.id.transitionName, (Object)name);
        }

        @Override
        public String getTransitionName(View v) {
            return (String)v.getTag(R.id.transitionName);
        }

        @Override
        public void setTransitionAlpha(View v, float alpha) {
            v.setAlpha(alpha);
        }

        @Override
        public String getAlphaProperty() {
            return "alpha";
        }

        @Override
        public void setTranslationZ(View view, float z) {
        }

        @Override
        public float getTranslationZ(View view) {
            return 0.0f;
        }

        @Override
        public View addGhostView(View view, ViewGroup viewGroup, Matrix matrix) {
            return null;
        }

        @Override
        public void removeGhostView(View view) {
        }

        @Override
        public void transformMatrixToGlobal(View view, Matrix matrix) {
        }

        @Override
        public void transformMatrixToLocal(View v, Matrix matrix) {
        }

        @Override
        public void setAnimationMatrix(View view, Matrix matrix) {
        }

        @Override
        public Object getWindowId(View view) {
            return null;
        }
    }

    static interface ViewUtilsImpl {
        public float getTransitionAlpha(View var1);

        public boolean isLaidOut(View var1, boolean var2);

        public void setClipBounds(View var1, Rect var2);

        public Rect getClipBounds(View var1);

        public void setTransitionName(View var1, String var2);

        public String getTransitionName(View var1);

        public void setTransitionAlpha(View var1, float var2);

        public String getAlphaProperty();

        public void setTranslationZ(View var1, float var2);

        public float getTranslationZ(View var1);

        public View addGhostView(View var1, ViewGroup var2, Matrix var3);

        public void removeGhostView(View var1);

        public void transformMatrixToGlobal(View var1, Matrix var2);

        public void transformMatrixToLocal(View var1, Matrix var2);

        public void setAnimationMatrix(View var1, Matrix var2);

        public Object getWindowId(View var1);
    }
}

