/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.adapter;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.adapter.Adapters;
import com.github.andrewoma.dexx.collection.internal.base.MappedIterable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MapAdapter<K, V>
extends AbstractMap<K, V>
implements java.util.Map<K, V> {
    private final Map<K, V> map;

    public MapAdapter(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.map.containsKey(key);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return Adapters.contains(this.map.values(), value);
    }

    @Override
    public V get(Object key) {
        try {
            return this.map.get(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull java.util.Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public int size() {
                return MapAdapter.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return MapAdapter.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return MapAdapter.this.containsKey(o);
            }

            @Override
            @NotNull
            public Iterator<K> iterator() {
                return MapAdapter.this.map.keys().iterator();
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return MapAdapter.this.map.keys().toArray();
            }

            @Override
            @NotNull
            public <T> T[] toArray(@NotNull T[] a) {
                return Adapters.toArray(MapAdapter.this.map.keys(), a);
            }

            @Override
            public boolean add(K k) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(@NotNull Collection<?> c) {
                return Adapters.containsAll(MapAdapter.this.map.keys(), c);
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends K> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public int size() {
                return MapAdapter.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return MapAdapter.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return MapAdapter.this.containsValue(o);
            }

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return MapAdapter.this.map.values().iterator();
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return MapAdapter.this.map.values().toArray();
            }

            @Override
            @NotNull
            public <T> T[] toArray(@NotNull T[] a) {
                return Adapters.toArray(MapAdapter.this.map.values(), a);
            }

            @Override
            public boolean add(V v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(@NotNull Collection<?> c) {
                return Adapters.containsAll(MapAdapter.this.map.values(), c);
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends V> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return MapAdapter.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return MapAdapter.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                try {
                    Map.Entry entry = (Map.Entry)o;
                    Pair pair = new Pair(entry.getKey(), entry.getValue());
                    return Adapters.contains(MapAdapter.this.map, pair);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return this.getEntries().iterator();
            }

            private MappedIterable<Map.Entry<K, V>, Pair<K, V>> getEntries() {
                return new MappedIterable(MapAdapter.this.map, new Function<Pair<K, V>, Map.Entry<K, V>>(){

                    @Override
                    public Map.Entry<K, V> invoke(final Pair<K, V> pair) {
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return pair.component1();
                            }

                            @Override
                            public V getValue() {
                                return pair.component2();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean equals(Object o) {
                                if (!(o instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry e = (Map.Entry)o;
                                return !(this.getKey() == null ? e.getKey() != null : !this.getKey().equals(e.getKey())) && !(this.getValue() == null ? e.getValue() != null : !this.getValue().equals(e.getValue()));
                            }

                            @Override
                            public int hashCode() {
                                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                            }

                            public String toString() {
                                return this.getKey() + "=" + this.getValue();
                            }
                        };
                    }
                });
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return this.getEntries().toArray();
            }

            @Override
            @NotNull
            public <T> T[] toArray(@NotNull T[] a) {
                return Adapters.toArray(this.getEntries(), a);
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

