/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.kwery.mapper;

import com.github.andrewoma.kwery.core.Row;
import com.github.andrewoma.kwery.mapper.SimpleConverter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"\b\u0004)\tB)\u001e:bi&|gnQ8om\u0016\u0014H/\u001a:\u000b\u0007\r|WN\u0003\u0004hSRDWO\u0019\u0006\nC:$'/Z<p[\u0006TQa[<fefTa!\\1qa\u0016\u0014(bD*j[BdWmQ8om\u0016\u0014H/\u001a:\u000b\u0011\u0011+(/\u0019;j_:TAA[1wC*!A/[7f\u0015\u0019a\u0014N\\5u})!QO\\5u\u00151!V-\u001c9pe\u0006dWK\\5u\u0015!!X-\u001c9pe\u0006d'K\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\b!%Qa\u0001\u0003\u0005\u0011\u000fa\u0001!\u0002\u0002\u0005\t!5Qa\u0001\u0003\u0006\u0011\u0019a\u0001!\u0002\u0002\u0005\u000b!1Aa\u0001G\u00033\u0019)\u0011\u0001C\u0002\n\u0007%\u0011Q!\u0001E\u0005kS)9\u0003Br\u00011\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001E\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u000b\t6!\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\r\u0001"})
public final class DurationConverter
extends SimpleConverter<Duration> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(DurationConverter.class);
    }

    public DurationConverter(final @JetValueParameter(name="unit") @NotNull TemporalUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
        super((Function2)new Function2<Row, String, Duration>(){

            public final Duration invoke(@JetValueParameter(name="row") @NotNull Row row, @JetValueParameter(name="c") @NotNull String c) {
                Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Duration duration = Duration.of(row.long(c), unit);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.of(row.long(c), unit)");
                return duration;
            }
        }, (Function1)new Function1<Duration, Long>(){

            public final long invoke(@JetValueParameter(name="it") @NotNull Duration it) {
                long l;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                TemporalUnit temporalUnit = unit;
                if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.NANOS)) {
                    l = it.toNanos();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MICROS)) {
                    l = it.toNanos() / (long)1000;
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MILLIS)) {
                    l = it.toMillis();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.SECONDS)) {
                    l = it.getSeconds();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MINUTES)) {
                    l = it.toMinutes();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.HOURS)) {
                    l = it.toHours();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.HALF_DAYS)) {
                    l = it.toDays() * (long)2;
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.DAYS)) {
                    l = it.toDays();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.WEEKS)) {
                    l = it.toDays() / (long)7;
                } else {
                    throw (Throwable)new UnsupportedOperationException();
                }
                return l;
            }
        });
    }
}

