/*
 * Copyright (c) 2015 Andrew O'Malley
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package com.github.andrewoma.kwery.mapper

import java.math.BigDecimal
import java.sql.Date
import java.sql.Time
import java.sql.Timestamp
import kotlin.reflect.KType
import kotlin.reflect.defaultType

val standardDefaults: Map<KType, *> = listOf(
        reifiedValue(true),
        reifiedValue(0.toByte()),
        reifiedValue(0.toChar()),
        reifiedValue(0.toShort()),
        reifiedValue(0),
        reifiedValue(0L),
        reifiedValue(0.toFloat()),
        reifiedValue(0.toDouble()),
        reifiedValue(BigDecimal(0)),
        reifiedValue(""),
        reifiedValue(Timestamp(0)),
        reifiedValue(Date(0)),
        reifiedValue(Time(0)),
        reifiedValue(ByteArray(0))
).toMap()

inline fun <reified T : Any> reifiedValue(default: T): Pair<KType, T> = T::class.defaultType to default

