/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.kwery.mapper;

import com.github.andrewoma.kwery.core.Row;
import com.github.andrewoma.kwery.mapper.SimpleConverter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/github/andrewoma/kwery/mapper/DurationConverter;", "Lcom/github/andrewoma/kwery/mapper/SimpleConverter;", "Ljava/time/Duration;", "unit", "Ljava/time/temporal/TemporalUnit;", "(Ljava/time/temporal/TemporalUnit;)V", "Companion", "com.github.andrewoma.kwery.mapper"})
public final class DurationConverter
extends SimpleConverter<Duration> {
    private static final Set<ChronoUnit> supported;
    public static final Companion Companion;

    public DurationConverter(final @NotNull TemporalUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
        super((Function2)new Function2<Row, String, Duration>(){

            public final Duration invoke(@NotNull Row row, @NotNull String c) {
                Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Duration duration = Duration.of(row.long(c), unit);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.of(row.long(c), unit)");
                return duration;
            }
        }, (Function1)new Function1<Duration, Long>(){

            /*
             * WARNING - void declaration
             */
            public final long invoke(@NotNull Duration duration) {
                void var2_4;
                void value$iv;
                long l;
                Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
                TemporalUnit temporalUnit = unit;
                if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.NANOS)) {
                    l = duration.toNanos();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MICROS)) {
                    l = duration.toNanos() / (long)1000;
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MILLIS)) {
                    l = duration.toMillis();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.SECONDS)) {
                    l = duration.getSeconds();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.MINUTES)) {
                    l = duration.toMinutes();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.HOURS)) {
                    l = duration.toHours();
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.HALF_DAYS)) {
                    l = duration.toHours() / (long)12;
                } else if (Intrinsics.areEqual((Object)temporalUnit, (Object)ChronoUnit.DAYS)) {
                    l = duration.toDays();
                } else {
                    throw (Throwable)new UnsupportedOperationException("");
                }
                long converted = l;
                boolean bl = Intrinsics.areEqual((Object)duration, (Object)Duration.of(converted, unit));
                if (value$iv == false) {
                    String message$iv = duration + " must be a whole number of " + unit + " and not overflow a Long";
                    throw (Throwable)new IllegalArgumentException(message$iv.toString());
                }
                return (long)var2_4;
            }
        });
        boolean value$iv = CollectionsKt.contains((Iterable)DurationConverter.Companion.getSupported(), (Object)unit);
        if (!value$iv) {
            String message$iv = "Only " + CollectionsKt.joinToString$default((Iterable)DurationConverter.Companion.getSupported(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " are supported";
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
    }

    static {
        Companion = new Companion(null);
        supported = SetsKt.setOf((Object[])new ChronoUnit[]{ChronoUnit.NANOS, ChronoUnit.MICROS, ChronoUnit.MILLIS, ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.HALF_DAYS, ChronoUnit.DAYS});
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/andrewoma/kwery/mapper/DurationConverter$Companion;", "", "()V", "supported", "", "Ljava/time/temporal/ChronoUnit;", "getSupported", "()Ljava/util/Set;", "com.github.andrewoma.kwery.mapper"})
    public static final class Companion {
        private final Set<ChronoUnit> getSupported() {
            return supported;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

