/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.kwery.mapper;

import com.github.andrewoma.kwery.mapper.Converter;
import com.github.andrewoma.kwery.mapper.OffsetDateTimeConverter;
import com.github.andrewoma.kwery.mapper.ZonedDateTimeConverter;
import com.github.andrewoma.kwery.mapper.durationToBigDecimalConverter;
import com.github.andrewoma.kwery.mapper.instantConverter;
import com.github.andrewoma.kwery.mapper.localDateConverter;
import com.github.andrewoma.kwery.mapper.localDateTimeConverter;
import com.github.andrewoma.kwery.mapper.localTimeConverter;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0011*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"%\u0010\u0006\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"nanosInSecond", "Ljava/math/BigDecimal;", "offsetDateTimeConverter", "Lcom/github/andrewoma/kwery/mapper/OffsetDateTimeConverter;", "getOffsetDateTimeConverter", "()Lcom/github/andrewoma/kwery/mapper/OffsetDateTimeConverter;", "timeConverters", "", "Ljava/lang/Class;", "Lcom/github/andrewoma/kwery/mapper/Converter;", "getTimeConverters", "()Ljava/util/Map;", "zonedDateTimeConverter", "Lcom/github/andrewoma/kwery/mapper/ZonedDateTimeConverter;", "getZonedDateTimeConverter", "()Lcom/github/andrewoma/kwery/mapper/ZonedDateTimeConverter;", "toBigDecimal", "Ljava/time/Duration;", "toDuration", "com.github.andrewoma.kwery.mapper"})
public final class TimeConvertersKt {
    @NotNull
    private static final OffsetDateTimeConverter offsetDateTimeConverter;
    @NotNull
    private static final ZonedDateTimeConverter zonedDateTimeConverter;
    @NotNull
    private static final Map<Class<?>, Converter<?>> timeConverters;
    private static final BigDecimal nanosInSecond;

    @NotNull
    public static final OffsetDateTimeConverter getOffsetDateTimeConverter() {
        return offsetDateTimeConverter;
    }

    @NotNull
    public static final ZonedDateTimeConverter getZonedDateTimeConverter() {
        return zonedDateTimeConverter;
    }

    @NotNull
    public static final Map<Class<?>, Converter<?>> getTimeConverters() {
        return timeConverters;
    }

    @NotNull
    public static final Duration toDuration(BigDecimal $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long seconds = $receiver.longValue();
        long nanoseconds = $receiver.remainder(BigDecimal.ONE).multiply(nanosInSecond).longValue();
        Duration duration = Duration.ofSeconds(seconds, nanoseconds);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(seconds, nanoseconds)");
        return duration;
    }

    @NotNull
    public static final BigDecimal toBigDecimal(Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BigDecimal bigDecimal = BigDecimal.valueOf($receiver.getSeconds()).add(BigDecimal.valueOf($receiver.getNano()).divide(nanosInSecond));
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"BigDecimal.valueOf(this.\u2026)).divide(nanosInSecond))");
        return bigDecimal;
    }

    static {
        Converter converter$iv;
        Pair pair;
        Object[] objectArray;
        offsetDateTimeConverter = new OffsetDateTimeConverter(null, 1, null);
        zonedDateTimeConverter = new ZonedDateTimeConverter(null, 1, null);
        Converter converter = localDateTimeConverter.INSTANCE;
        int n = 0;
        Object[] objectArray2 = objectArray = new Pair[7];
        objectArray[n] = pair = TuplesKt.to(LocalDateTime.class, (Object)converter$iv);
        converter$iv = localDateConverter.INSTANCE;
        n = 1;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(LocalDate.class, (Object)converter$iv);
        converter$iv = localTimeConverter.INSTANCE;
        n = 2;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(LocalTime.class, (Object)converter$iv);
        converter$iv = instantConverter.INSTANCE;
        n = 3;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(Instant.class, (Object)converter$iv);
        converter$iv = durationToBigDecimalConverter.INSTANCE;
        n = 4;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(Duration.class, (Object)converter$iv);
        converter$iv = offsetDateTimeConverter;
        n = 5;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(OffsetDateTime.class, (Object)converter$iv);
        converter$iv = zonedDateTimeConverter;
        n = 6;
        objectArray = objectArray2;
        objectArray[n] = pair = TuplesKt.to(ZonedDateTime.class, (Object)converter$iv);
        timeConverters = MapsKt.toMap((Iterable)CollectionsKt.listOf((Object[])objectArray2));
        BigDecimal bigDecimal = BigDecimal.valueOf(1000000000L);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"BigDecimal.valueOf(1000000000L)");
        nanosInSecond = bigDecimal;
    }
}

