/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BonjourService
implements Parcelable {
    public static final int LOST = 256;
    public static final Parcelable.Creator<BonjourService> CREATOR = new Parcelable.Creator<BonjourService>(){

        @NonNull
        public BonjourService createFromParcel(@NonNull Parcel source) {
            return new BonjourService(source);
        }

        @NonNull
        public BonjourService[] newArray(int size) {
            return new BonjourService[size];
        }
    };
    private final int flags;
    private final String serviceName;
    private final String regType;
    private final String domain;
    private final List<InetAddress> inetAddresses;
    private final Map<String, String> dnsRecords;
    private final int ifIndex;
    private final String hostname;
    private final int port;

    protected BonjourService(@NonNull Builder builder) {
        this.flags = builder.flags;
        this.serviceName = builder.serviceName;
        this.regType = builder.regType;
        this.domain = builder.domain;
        this.ifIndex = builder.ifIndex;
        this.inetAddresses = Collections.unmodifiableList(builder.inetAddresses);
        this.dnsRecords = Collections.unmodifiableMap(builder.dnsRecords);
        this.hostname = builder.hostname;
        this.port = builder.port;
    }

    protected BonjourService(@NonNull Parcel in) {
        this.flags = in.readInt();
        this.serviceName = in.readString();
        this.regType = in.readString();
        this.domain = in.readString();
        this.dnsRecords = BonjourService.readMap(in);
        this.inetAddresses = BonjourService.readAddresses(in);
        this.ifIndex = in.readInt();
        this.hostname = in.readString();
        this.port = in.readInt();
    }

    private static void writeAddresses(Parcel dest, List<InetAddress> val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int n = val.size();
        dest.writeInt(n);
        for (InetAddress address : val) {
            dest.writeSerializable((Serializable)address);
        }
    }

    private static List<InetAddress> readAddresses(Parcel in) {
        int n = in.readInt();
        if (n < 0) {
            return null;
        }
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        for (int i = 0; i < n; ++i) {
            result.add((InetAddress)in.readSerializable());
        }
        return Collections.unmodifiableList(result);
    }

    private static void writeMap(Parcel dest, Map<String, String> val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int n = val.size();
        dest.writeInt(n);
        for (Map.Entry<String, String> entry : val.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    private static Map<String, String> readMap(Parcel in) {
        int n = in.readInt();
        if (n < 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String key = in.readString();
            String value = in.readString();
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    public int getFlags() {
        return this.flags;
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NonNull
    public String getRegType() {
        return this.regType;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public Map<String, String> getTxtRecords() {
        return this.dnsRecords;
    }

    @Nullable
    public Inet4Address getInet4Address() {
        for (InetAddress inetAddress : this.inetAddresses) {
            if (!(inetAddress instanceof Inet4Address)) continue;
            return (Inet4Address)inetAddress;
        }
        return null;
    }

    @Nullable
    public Inet6Address getInet6Address() {
        for (InetAddress inetAddress : this.inetAddresses) {
            if (!(inetAddress instanceof Inet6Address)) continue;
            return (Inet6Address)inetAddress;
        }
        return null;
    }

    public List<InetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    public boolean isLost() {
        return (this.flags & 0x100) == 256;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BonjourService)) {
            return false;
        }
        BonjourService that = (BonjourService)o;
        if (this.ifIndex != that.ifIndex) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.regType != null ? !this.regType.equals(that.regType) : that.regType != null) {
            return false;
        }
        return !(this.domain == null ? that.domain != null : !this.domain.equals(that.domain));
    }

    public int hashCode() {
        int result = this.serviceName != null ? this.serviceName.hashCode() : 0;
        result = 31 * result + (this.regType != null ? this.regType.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + this.ifIndex;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.flags);
        dest.writeString(this.serviceName);
        dest.writeString(this.regType);
        dest.writeString(this.domain);
        BonjourService.writeMap(dest, this.dnsRecords);
        BonjourService.writeAddresses(dest, this.inetAddresses);
        dest.writeInt(this.ifIndex);
        dest.writeString(this.hostname);
        dest.writeInt(this.port);
    }

    @NonNull
    public String toString() {
        return "BonjourService{flags=" + this.flags + ", domain='" + this.domain + '\'' + ", regType='" + this.regType + '\'' + ", serviceName='" + this.serviceName + '\'' + ", dnsRecords=" + this.dnsRecords + ", ifIndex=" + this.ifIndex + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + '}';
    }

    public static class Builder {
        private final int flags;
        private final String serviceName;
        private final String regType;
        private final String domain;
        private final int ifIndex;
        private List<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        private Map<String, String> dnsRecords = new HashMap<String, String>();
        private String hostname;
        private int port;

        public Builder(int flags, int ifIndex, @NonNull String serviceName, @NonNull String regType, String domain) {
            this.flags = flags;
            this.serviceName = serviceName;
            this.regType = regType;
            this.domain = domain;
            this.ifIndex = ifIndex;
        }

        public Builder(@NonNull BonjourService service) {
            this.flags = service.flags;
            this.serviceName = service.serviceName;
            this.regType = service.regType;
            this.domain = service.domain;
            this.ifIndex = service.ifIndex;
            this.dnsRecords = new HashMap<String, String>(service.dnsRecords);
            this.inetAddresses = new ArrayList<InetAddress>(service.inetAddresses);
            this.hostname = service.hostname;
            this.port = service.port;
        }

        @NonNull
        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @NonNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NonNull
        public Builder dnsRecords(Map<String, String> dnsRecords) {
            this.dnsRecords = dnsRecords;
            return this;
        }

        @NonNull
        public Builder inet4Address(Inet4Address inet4Address) {
            this.inetAddresses.add(inet4Address);
            return this;
        }

        @NonNull
        public Builder inet6Address(Inet6Address inet6Address) {
            this.inetAddresses.add(inet6Address);
            return this;
        }

        @NonNull
        public BonjourService build() {
            return new BonjourService(this);
        }

        public void inetAddress(InetAddress inetAddress) {
            this.inetAddresses.add(inetAddress);
        }
    }
}

