/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import com.github.druk.dnssd.DNSSD;
import com.github.druk.dnssd.DNSSDService;
import com.github.druk.dnssd.QueryListener;
import com.github.druk.rxdnssd.BonjourService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import rx.Subscriber;

class RxQueryListener
implements QueryListener {
    private final Subscriber<? super BonjourService> subscriber;
    private final BonjourService.Builder builder;
    private final boolean completable;

    RxQueryListener(Subscriber<? super BonjourService> subscriber, BonjourService.Builder builder, boolean completable) {
        this.subscriber = subscriber;
        this.builder = builder;
        this.completable = completable;
    }

    public void queryAnswered(DNSSDService query, int flags, int ifIndex, String fullName, int rrtype, int rrclass, byte[] rdata, int ttl) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        if (rrtype == 1 || rrtype == 28) {
            try {
                InetAddress inetAddress = InetAddress.getByAddress(rdata);
                this.builder.inetAddress(inetAddress);
            }
            catch (UnknownHostException e) {
                this.subscriber.onError((Throwable)e);
            }
        } else if (rrtype == 16) {
            this.builder.dnsRecords(DNSSD.parseTXTRecords((byte[])rdata));
        } else {
            this.subscriber.onError((Throwable)new Exception("Unsupported type of record: " + rrtype));
        }
        this.subscriber.onNext((Object)this.builder.build());
        if (this.completable) {
            this.subscriber.onCompleted();
        }
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        this.subscriber.onError((Throwable)new RuntimeException("DNSSD queryRecord error: " + errorCode));
    }
}

