/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import com.github.druk.dnssd.DNSSDRegistration;
import com.github.druk.dnssd.DNSSDService;
import com.github.druk.dnssd.RegisterListener;
import com.github.druk.rxdnssd.BonjourService;
import rx.Subscriber;

class RxRegisterListener
implements RegisterListener {
    private final Subscriber<? super BonjourService> subscriber;

    RxRegisterListener(Subscriber<? super BonjourService> subscriber) {
        this.subscriber = subscriber;
    }

    public void serviceRegistered(DNSSDRegistration registration, int flags, String serviceName, String regType, String domain) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        BonjourService service = new BonjourService.Builder(flags, 0, serviceName, regType, domain).build();
        this.subscriber.onNext((Object)service);
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        this.subscriber.onError((Throwable)new RuntimeException("DNSSD browse error: " + errorCode));
    }
}

