/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import com.github.druk.dnssd.DNSSDService;
import com.github.druk.dnssd.ResolveListener;
import com.github.druk.rxdnssd.BonjourService;
import java.util.Map;
import rx.Subscriber;

class RxResolveListener
implements ResolveListener {
    private final Subscriber<? super BonjourService> subscriber;
    private final BonjourService.Builder builder;

    RxResolveListener(Subscriber<? super BonjourService> subscriber, BonjourService service) {
        this.subscriber = subscriber;
        this.builder = new BonjourService.Builder(service);
    }

    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullName, String hostName, int port, Map<String, String> txtRecord) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        BonjourService bonjourService = this.builder.port(port).hostname(hostName).dnsRecords(txtRecord).build();
        this.subscriber.onNext((Object)bonjourService);
        this.subscriber.onCompleted();
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        this.subscriber.onError((Throwable)new RuntimeException("DNSSD resolve error: " + errorCode));
    }
}

