/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import androidx.annotation.NonNull;
import com.github.druk.dnssd.BrowseListener;
import com.github.druk.dnssd.DNSSD;
import com.github.druk.dnssd.DNSSDException;
import com.github.druk.dnssd.DNSSDService;
import com.github.druk.dnssd.QueryListener;
import com.github.druk.dnssd.RegisterListener;
import com.github.druk.dnssd.ResolveListener;
import com.github.druk.dnssd.TXTRecord;
import com.github.druk.rxdnssd.BonjourService;
import com.github.druk.rxdnssd.RxBrowseListener;
import com.github.druk.rxdnssd.RxDnssd;
import com.github.druk.rxdnssd.RxQueryListener;
import com.github.druk.rxdnssd.RxRegisterListener;
import com.github.druk.rxdnssd.RxResolveListener;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;

abstract class RxDnssdCommon
implements RxDnssd {
    private final DNSSD mDNSSD;

    RxDnssdCommon(DNSSD dnssd) {
        this.mDNSSD = dnssd;
    }

    public DNSSD getDNSSD() {
        return this.mDNSSD;
    }

    @Override
    @NonNull
    public Observable<BonjourService> browse(@NonNull String regType, @NonNull String domain) {
        return this.createObservable(subscriber -> this.mDNSSD.browse(0, 0, regType, domain, (BrowseListener)new RxBrowseListener((Subscriber<? super BonjourService>)subscriber)));
    }

    @Override
    @NonNull
    public Observable.Transformer<BonjourService, BonjourService> resolve() {
        return observable -> observable.flatMap(bs -> {
            if ((bs.getFlags() & 0x100) == 256) {
                return Observable.just((Object)bs);
            }
            return this.createObservable(subscriber -> this.mDNSSD.resolve(bs.getFlags(), bs.getIfIndex(), bs.getServiceName(), bs.getRegType(), bs.getDomain(), (ResolveListener)new RxResolveListener((Subscriber<? super BonjourService>)subscriber, (BonjourService)bs)));
        });
    }

    @Override
    @Deprecated
    @NonNull
    public Observable.Transformer<BonjourService, BonjourService> queryRecords() {
        return observable -> observable.flatMap(bs -> {
            if ((bs.getFlags() & 0x100) == 256) {
                return Observable.just((Object)bs);
            }
            BonjourService.Builder builder = new BonjourService.Builder((BonjourService)bs);
            return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 1, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, true))).mergeWith(this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 28, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, true))));
        });
    }

    @Override
    @NonNull
    public Observable.Transformer<BonjourService, BonjourService> queryIPRecords() {
        return observable -> observable.flatMap(bs -> {
            if ((bs.getFlags() & 0x100) == 256) {
                return Observable.just((Object)bs);
            }
            BonjourService.Builder builder = new BonjourService.Builder((BonjourService)bs);
            return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 1, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, true))).mergeWith(this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 28, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, true))));
        });
    }

    @Override
    @NonNull
    public Observable.Transformer<BonjourService, BonjourService> queryIPV4Records() {
        return observable -> observable.flatMap(bs -> {
            if ((bs.getFlags() & 0x100) == 256) {
                return Observable.just((Object)bs);
            }
            return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 1, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, new BonjourService.Builder((BonjourService)bs), true)));
        });
    }

    @Override
    @NonNull
    public Observable.Transformer<BonjourService, BonjourService> queryIPV6Records() {
        return observable -> observable.flatMap(bs -> {
            if ((bs.getFlags() & 0x100) == 256) {
                return Observable.just((Object)bs);
            }
            return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 28, 1, true, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, new BonjourService.Builder((BonjourService)bs), true)));
        });
    }

    @Override
    @NonNull
    public Observable<BonjourService> queryIPRecords(BonjourService bs) {
        if ((bs.getFlags() & 0x100) == 256) {
            return Observable.just((Object)bs);
        }
        BonjourService.Builder builder = new BonjourService.Builder(bs);
        return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 1, 1, false, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, false))).mergeWith(this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), 28, 1, false, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, builder, false))));
    }

    @Override
    @NonNull
    public Observable<BonjourService> queryIPV4Records(BonjourService bs) {
        return this.queryRecords(bs, 1);
    }

    @Override
    @NonNull
    public Observable<BonjourService> queryIPV6Records(BonjourService bs) {
        return this.queryRecords(bs, 28);
    }

    @Override
    @NonNull
    public Observable<BonjourService> queryTXTRecords(BonjourService bs) {
        return this.queryRecords(bs, 16);
    }

    private Observable<BonjourService> queryRecords(BonjourService bs, int type) {
        if ((bs.getFlags() & 0x100) == 256) {
            return Observable.just((Object)bs);
        }
        return this.createObservable(subscriber -> this.mDNSSD.queryRecord(0, bs.getIfIndex(), bs.getHostname(), type, 1, false, (QueryListener)new RxQueryListener((Subscriber<? super BonjourService>)subscriber, new BonjourService.Builder(bs), false)));
    }

    @Override
    @NonNull
    public Observable<BonjourService> register(@NonNull BonjourService bs) {
        return this.createObservable(subscriber -> this.mDNSSD.register(bs.getFlags(), bs.getIfIndex(), bs.getServiceName(), bs.getRegType(), bs.getDomain(), null, bs.getPort(), RxDnssdCommon.createTxtRecord(bs.getTxtRecords()), (RegisterListener)new RxRegisterListener((Subscriber<? super BonjourService>)subscriber)));
    }

    private <T> Observable<T> createObservable(DNSSDServiceCreator<T> creator) {
        DNSSDServiceAction<T> action = new DNSSDServiceAction<T>(creator);
        return Observable.unsafeCreate(action).doOnUnsubscribe(action);
    }

    private static TXTRecord createTxtRecord(Map<String, String> records) {
        TXTRecord txtRecord = new TXTRecord();
        for (Map.Entry<String, String> entry : records.entrySet()) {
            txtRecord.set(entry.getKey(), entry.getValue());
        }
        return txtRecord;
    }

    private static interface DNSSDServiceCreator<T> {
        public DNSSDService getService(Subscriber<? super T> var1) throws DNSSDException;
    }

    private static class DNSSDServiceAction<T>
    implements Observable.OnSubscribe<T>,
    Action0 {
        private final DNSSDServiceCreator<T> creator;
        private DNSSDService service;

        DNSSDServiceAction(DNSSDServiceCreator<T> creator) {
            this.creator = creator;
        }

        public void call(Subscriber<? super T> subscriber) {
            if (!subscriber.isUnsubscribed() && this.creator != null) {
                try {
                    this.service = this.creator.getService(subscriber);
                }
                catch (DNSSDException e) {
                    subscriber.onError((Throwable)e);
                }
            }
        }

        public void call() {
            if (this.service != null) {
                this.service.stop();
                this.service = null;
            }
        }
    }
}

