/*
 * Decompiled with CFR 0.152.
 */
package com.github.druk.rxdnssd;

import com.github.druk.dnssd.BrowseListener;
import com.github.druk.dnssd.DNSSDService;
import com.github.druk.rxdnssd.BonjourService;
import rx.Subscriber;

class RxBrowseListener
implements BrowseListener {
    private final Subscriber<? super BonjourService> subscriber;

    RxBrowseListener(Subscriber<? super BonjourService> subscriber) {
        this.subscriber = subscriber;
    }

    public void serviceFound(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        BonjourService service = new BonjourService.Builder(flags, ifIndex, serviceName, regType, domain).build();
        this.subscriber.onNext((Object)service);
    }

    public void serviceLost(DNSSDService browser, int flags, int ifIndex, String serviceName, String regType, String domain) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        BonjourService service = new BonjourService.Builder(flags | 0x100, ifIndex, serviceName, regType, domain).build();
        this.subscriber.onNext((Object)service);
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        if (this.subscriber.isUnsubscribed()) {
            return;
        }
        this.subscriber.onError((Throwable)new RuntimeException("DNSSD browse error: " + errorCode));
    }
}

