/*
 * Decompiled with CFR 0.152.
 */
package com.andy.idempotent.annotation;

import com.alibaba.fastjson.JSON;
import com.andy.idempotent.annotation.Idempotent;
import com.andy.idempotent.model.IdempotentContext;
import com.andy.idempotent.service.IdempotentService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-1)
public class IdempotentInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdempotentInterceptor.class);
    @Autowired
    private IdempotentService idempotentService;
    @Value(value="${spring.application.name:}")
    public String defaultPrjName;

    @Around(value="@annotation(idempotent)")
    public Object proceed(final ProceedingJoinPoint joinPoint, final Idempotent idempotent) throws Throwable {
        final Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        final MethodSignature methodSignature = (MethodSignature)signature;
        final String[] paramNames = methodSignature.getParameterNames();
        final String[] idempotentColumns = idempotent.idempotentColumns();
        Object retObj = this.idempotentService.handle(new IdempotentService.IdempotentCallback<Object>(){

            @Override
            public void initContext(IdempotentContext context) {
                context.setPrjName(StringUtils.isBlank((CharSequence)idempotent.prjName()) ? IdempotentInterceptor.this.defaultPrjName : idempotent.prjName());
                context.setInterfaceName(StringUtils.isBlank((CharSequence)idempotent.interfaceName()) ? IdempotentInterceptor.this.getMethodName(methodSignature) : idempotent.interfaceName());
                context.setIdempotentMinutes(idempotent.idempotentMinutes());
                context.setResponseStrategy(idempotent.responseStrategy());
                Map idempotentParamMap = new TreeMap();
                idempotentParamMap = IdempotentInterceptor.this.isIdempotentColumnsEmpty(idempotentColumns) ? IdempotentInterceptor.this.generateAllParamJson(args, paramNames) : IdempotentInterceptor.this.generateParamJson(args, paramNames, idempotentColumns);
                context.setBizColumnValues(JSON.toJSONString(idempotentParamMap));
                if (idempotent.idempotentParamOnly()) {
                    context.setRequestParam(idempotentParamMap);
                } else {
                    context.setRequestParam(IdempotentInterceptor.this.generateAllParamJson(args, paramNames));
                }
            }

            @Override
            public Object execute() throws Throwable {
                return joinPoint.proceed();
            }
        });
        return JSON.parseObject((String)JSON.toJSONString((Object)retObj), (Class)methodSignature.getReturnType());
    }

    private boolean isIdempotentColumnsEmpty(String[] idempotentColumns) {
        return idempotentColumns == null || idempotentColumns.length == 0 || Arrays.asList(idempotentColumns).stream().allMatch(s -> StringUtils.isBlank((CharSequence)s));
    }

    private String getMethodName(MethodSignature methodSignature) {
        String className = methodSignature.getDeclaringTypeName();
        if (className.indexOf(".") > -1) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        return String.format("%s:%s", className, methodSignature.getName());
    }

    private Map<String, Object> generateAllParamJson(Object[] args, String[] paramNames) {
        TreeMap<String, Object> idempotentParamMap = new TreeMap<String, Object>();
        if (paramNames != null && paramNames.length > 0) {
            for (int i = 0; i < paramNames.length; ++i) {
                idempotentParamMap.put(paramNames[i], args[i]);
            }
        }
        return idempotentParamMap;
    }

    private Map<String, Object> generateParamJson(Object[] args, String[] paramNames, String[] idempotentColumns) {
        TreeMap<String, Object> idempotentParamMap = new TreeMap<String, Object>();
        for (String idempotentColumn : idempotentColumns) {
            if (!StringUtils.isNotBlank((CharSequence)idempotentColumn)) continue;
            idempotentParamMap.put(idempotentColumn, this.getParamAttributeValue(args, paramNames, idempotentColumn));
        }
        return idempotentParamMap;
    }

    private Object getParamAttributeValue(Object[] args, String[] parameterNames, String expression) {
        if (expression.indexOf(".") < 0) {
            return args[ArrayUtils.indexOf((Object[])parameterNames, (Object)expression)];
        }
        try {
            Object arg = args[ArrayUtils.indexOf((Object[])parameterNames, (Object)expression.substring(0, expression.indexOf(".")))];
            String fieldName = expression.substring(expression.indexOf(".") + 1);
            String typeName = this.getFieldTypeName(arg.getClass().getDeclaredFields(), fieldName);
            if ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName)) {
                return this.getBooleanFiledValueTyName(fieldName, arg);
            }
            return this.getFiledValueByName(fieldName, arg, "get");
        }
        catch (Throwable e) {
            log.error("####### Parameters cannot be obtained. Check idempotent configuration,", e);
            throw new RuntimeException("Parameters cannot be obtained. Check idempotent configuration");
        }
    }

    private Object getBooleanFiledValueTyName(String fieldName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object retObj = null;
        try {
            retObj = this.getFiledValueByName(fieldName, arg, "get");
        }
        catch (Exception e) {
            log.warn("####### get boolean value of field '{}' fail by 'get' Method, try to use 'is' method", (Object)fieldName);
        }
        if (retObj == null) {
            retObj = this.getFiledValueByName(fieldName, arg, "is");
        }
        return retObj;
    }

    private Object getFiledValueByName(String fieldName, Object arg, String prefix) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = arg.getClass().getMethod(prefix + this.firstUpcase(fieldName), new Class[0]);
        method.setAccessible(true);
        return method.invoke(arg, new Object[0]);
    }

    private String getFieldTypeName(Field[] fields, String fieldName) {
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field.getType().getName();
        }
        return null;
    }

    private String firstUpcase(String property) {
        char[] chars = property.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }
}

