/*
 * Decompiled with CFR 0.152.
 */
package com.andy.idempotent.lock;

import com.andy.idempotent.lock.DistributedLockService;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisDistributedLockServiceImpl
implements DistributedLockService {
    public static final Logger LOGGER = LoggerFactory.getLogger(RedisDistributedLockServiceImpl.class);
    public static final Integer REDISKEY_EXPIRE = 120;
    @Resource(name="stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;
    @Resource(name="stringRedisTemplate")
    private ValueOperations<String, String> redisStringOps;

    @Override
    public <T> T doWithLock(String bizLockName, DistributedLockService.LockCallback<T> lockCallback) {
        String redisKey = String.format("SimpleLock:lockName:%s", bizLockName);
        String redisValue = UUID.randomUUID().toString();
        try {
            while (!this.setNX(redisKey, redisValue, REDISKEY_EXPIRE)) {
                LOGGER.info("have not got redis lock, redisKey={},sleep 100 milliseconds...", (Object)redisKey);
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            T t = lockCallback.doBiz();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (redisValue.equals(this.redisStringOps.get((Object)redisKey))) {
                    this.redisTemplate.delete((Object)redisKey);
                }
            }
            catch (Throwable e) {
                LOGGER.error("delete redis lock error, redisKey={}", (Object)redisKey, (Object)e);
            }
        }
    }

    private boolean setNX(String key, String value, Integer seconds) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            Boolean result = connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value), Expiration.seconds((long)seconds.intValue()), RedisStringCommands.SetOption.SET_IF_ABSENT);
            return result == null ? false : result;
        });
    }
}

