/*
 * Decompiled with CFR 0.152.
 */
package com.andy.idempotent.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.andy.idempotent.error.CommonErrorEnum;
import com.andy.idempotent.error.IdempotentException;
import com.andy.idempotent.lock.DistributedLockService;
import com.andy.idempotent.mapper.IdempotentRequestMapper;
import com.andy.idempotent.model.IdempotentContext;
import com.andy.idempotent.model.IdempotentRequest;
import com.andy.idempotent.service.IdempotentService;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service(value="idempotentService")
public class IdempotentServiceImpl
implements IdempotentService {
    public static final Logger log = LoggerFactory.getLogger(IdempotentServiceImpl.class);
    @Resource(name="stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;
    @Resource(name="stringRedisTemplate")
    private ValueOperations<String, String> redisStringOps;
    public static final String IDEMPOTENT_LOCK = "idempotent:prjName:%s:sign:%s";
    public static final String IDEMPOTENT_REDIS_KEY = "idempotent:sign:%s";
    public static final Integer DEFAULT_IDEMPOTENT_MINUTES = 1440;
    public static final Integer BIZ_COLUMN_LENGTH_THRESHOLD = 512;
    public static final Integer REQUEST_PARAM_LENGTH_THRESHOLD = 2048;
    @Autowired
    private IdempotentRequestMapper idempotentRequestMapper;
    @Autowired
    private DistributedLockService distributedLockService;

    private IdempotentRequest getIdempotentRequestFromRedis(String sign) {
        String redisIdemptObj = (String)this.redisStringOps.get((Object)sign);
        if (StringUtils.isNotBlank((CharSequence)redisIdemptObj)) {
            return (IdempotentRequest)JSON.parseObject((String)redisIdemptObj, IdempotentRequest.class);
        }
        return null;
    }

    @Override
    public <T> T handle(final IdempotentService.IdempotentCallback<T> idempotentCallback) {
        final IdempotentContext context = new IdempotentContext();
        idempotentCallback.initContext(context);
        if (StringUtils.isBlank((CharSequence)context.getPrjName())) {
            throw new IllegalArgumentException("prjName can not be null when calls method[IdempotentServiceImpl.handle]");
        }
        if (StringUtils.isBlank((CharSequence)context.getInterfaceName())) {
            throw new IllegalArgumentException("interfaceName can not be null when calls method[IdempotentServiceImpl.handle]");
        }
        final String sign = this.getSign(context);
        return this.distributedLockService.doWithLock(String.format(IDEMPOTENT_LOCK, context.getPrjName(), sign), new DistributedLockService.LockCallback<T>(){

            @Override
            public T doBiz() throws Throwable {
                IdempotentRequest idempotentRequest = IdempotentServiceImpl.this.getIdempotentRequestFromRedis(String.format(IdempotentServiceImpl.IDEMPOTENT_REDIS_KEY, sign));
                if (idempotentRequest == null && (idempotentRequest = IdempotentServiceImpl.this.idempotentRequestMapper.getRequestBefore(sign)) != null) {
                    IdempotentServiceImpl.this.redisStringOps.set((Object)String.format(IdempotentServiceImpl.IDEMPOTENT_REDIS_KEY, sign), (Object)JSON.toJSONString((Object)idempotentRequest), (long)IdempotentServiceImpl.this.getRedisIdempotentSeconds(context.getIdempotentMinutes()).intValue(), TimeUnit.SECONDS);
                }
                if (idempotentRequest != null && IdempotentRequest.STATUS_SUCCESS.equals(idempotentRequest.getStatus()) && (idempotentRequest.getValidEndTime() == null || idempotentRequest.getValidEndTime().compareTo(new Date()) > 0)) {
                    if (1 == context.getResponseStrategy()) {
                        throw new IdempotentException(CommonErrorEnum.IDEMPOTENT_REQUEST_EXIST.code(), CommonErrorEnum.IDEMPOTENT_REQUEST_EXIST.message());
                    }
                    log.info("####### exist valid idempotent result, no need to call biz method, return directly, idempotentRequest={}", (Object)JSON.toJSONString((Object)idempotentRequest));
                    Type type = ((ParameterizedType)idempotentCallback.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                    if (Void.class.getName().equals(type.getTypeName())) {
                        return null;
                    }
                    return JSON.parseObject((String)idempotentRequest.getResponse(), (Type)type, (Feature[])new Feature[0]);
                }
                if (idempotentRequest == null || IdempotentRequest.STATUS_FAIL.equals(idempotentRequest.getStatus())) {
                    try {
                        idempotentRequest = new IdempotentRequest();
                        idempotentRequest.setBizColumnValues(IdempotentServiceImpl.this.getValidBizColumnsValues(context.getBizColumnValues()));
                        idempotentRequest.setPrjName(context.getPrjName());
                        idempotentRequest.setInterfaceName(context.getInterfaceName());
                        idempotentRequest.setRequestParam(IdempotentServiceImpl.this.getValidRequestParam(context.getRequestParam()));
                        idempotentRequest.setSign(sign);
                        idempotentRequest.setStatus(IdempotentRequest.STATUS_NEW);
                        if (context.getIdempotentMinutes() != null && context.getIdempotentMinutes() > 0) {
                            idempotentRequest.setValidEndTime(DateUtils.addMinutes((Date)new Date(), (int)context.getIdempotentMinutes()));
                        }
                        IdempotentServiceImpl.this.idempotentRequestMapper.insert(idempotentRequest);
                    }
                    catch (Exception e) {
                        log.error("####### fail when add idempotentRequest, idempotentRequest={}", (Object)JSON.toJSONString((Object)idempotentRequest), (Object)e);
                        throw new RuntimeException(e);
                    }
                } else {
                    log.warn("####### abnormal idempotent record {}", (Object)JSON.toJSONString((Object)idempotentRequest));
                }
                Object result = null;
                try {
                    result = idempotentCallback.execute();
                }
                catch (Throwable e) {
                    log.warn("####### fail when execute biz method, idempotentRequest={}", (Object)JSON.toJSONString((Object)idempotentRequest));
                    if (idempotentRequest.getId() != null) {
                        IdempotentServiceImpl.this.idempotentRequestMapper.updateStatusByPrimaryKey(idempotentRequest.getId(), idempotentRequest.getStatus(), IdempotentRequest.STATUS_FAIL);
                    }
                    if (e instanceof RuntimeException) {
                        throw e;
                    }
                    throw new RuntimeException(e);
                }
                try {
                    if (idempotentRequest.getId() != null) {
                        idempotentRequest.setResponse(JSON.toJSONString(result));
                        IdempotentServiceImpl.this.idempotentRequestMapper.updateRequestResult(idempotentRequest.getId(), idempotentRequest.getStatus(), IdempotentRequest.STATUS_SUCCESS, idempotentRequest.getResponse());
                        idempotentRequest.setStatus(IdempotentRequest.STATUS_SUCCESS);
                        IdempotentServiceImpl.this.redisStringOps.set((Object)String.format(IdempotentServiceImpl.IDEMPOTENT_REDIS_KEY, sign), (Object)JSON.toJSONString((Object)idempotentRequest), (long)IdempotentServiceImpl.this.getRedisIdempotentSeconds(context.getIdempotentMinutes()).intValue(), TimeUnit.SECONDS);
                    }
                }
                catch (Throwable e) {
                    log.error("####### fail when update idempotentRequest, idempotentRequest={}", (Object)idempotentRequest, (Object)e);
                }
                return result;
            }
        });
    }

    protected Map<String, Object> getValidRequestParam(Map<String, Object> requestParam) {
        if (requestParam == null) {
            return null;
        }
        String reqeustParamJson = JSON.toJSONString(requestParam);
        if (reqeustParamJson.length() > REQUEST_PARAM_LENGTH_THRESHOLD) {
            HashMap<String, Object> trimedParams = new HashMap<String, Object>();
            trimedParams.put("trimmedValue", reqeustParamJson.substring(0, 64));
            return trimedParams;
        }
        return requestParam;
    }

    protected String getValidBizColumnsValues(String bizColumnValues) {
        if (!StringUtils.isBlank((CharSequence)bizColumnValues) && bizColumnValues.length() > BIZ_COLUMN_LENGTH_THRESHOLD) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("trimmedValue", (Object)bizColumnValues.substring(0, 64));
            return jsonObject.toJSONString();
        }
        return bizColumnValues;
    }

    private Integer getRedisIdempotentSeconds(Integer idempotentMinutes) {
        if (idempotentMinutes > 0 && idempotentMinutes < DEFAULT_IDEMPOTENT_MINUTES) {
            return idempotentMinutes * 60;
        }
        return DEFAULT_IDEMPOTENT_MINUTES * 60;
    }

    private String getSign(IdempotentContext context) {
        try {
            return DigestUtils.md5DigestAsHex((byte[])String.format("prjName:%s:interfaceName:%s:bizColumnValues:%s", context.getPrjName(), context.getInterfaceName(), context.getBizColumnValues()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("####### get idempotent sign error");
            throw new RuntimeException("####### get idempotent sign error", e);
        }
    }
}

