/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator;

import com.github.anhem.testpopulator.config.BuilderPattern;
import com.github.anhem.testpopulator.config.PopulateConfig;
import com.github.anhem.testpopulator.config.Strategy;
import com.github.anhem.testpopulator.exception.PopulateException;
import com.github.anhem.testpopulator.internal.carrier.ClassCarrier;
import com.github.anhem.testpopulator.internal.carrier.CollectionCarrier;
import com.github.anhem.testpopulator.internal.carrier.TypeCarrier;
import com.github.anhem.testpopulator.internal.object.ObjectFactory;
import com.github.anhem.testpopulator.internal.object.ObjectFactoryImpl;
import com.github.anhem.testpopulator.internal.object.ObjectFactoryVoid;
import com.github.anhem.testpopulator.internal.util.ImmutablesUtil;
import com.github.anhem.testpopulator.internal.util.LombokUtil;
import com.github.anhem.testpopulator.internal.util.PopulateUtil;
import com.github.anhem.testpopulator.internal.value.ValueFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PopulateFactory {
    static final String MISSING_COLLECTION_TYPE = "Failed to find type for collection '%s'";
    static final String NO_MATCHING_STRATEGY = "Unable to populate '%s'. No matching strategy found. Tried with %s. Try another strategy or override population for this class";
    static final String FAILED_TO_SET_FIELD = "Failed to set field '%s' in object of class %s";
    static final String FAILED_TO_CALL_METHOD = "Failed to call method '%s' in object of class '%s'";
    static final String FAILED_TO_CREATE_OBJECT = "Failed to create object of '%s' using '%s' strategy";
    static final String FAILED_TO_CREATE_COLLECTION = "Failed to create and populate collection '%s'";
    public static final String BUILD_METHOD = "build";
    public static final String BUILDER_METHOD = "builder";
    private final PopulateConfig populateConfig;
    private final ValueFactory valueFactory;

    public PopulateFactory() {
        this(PopulateConfig.builder().build());
    }

    public PopulateFactory(PopulateConfig populateConfig) {
        this.populateConfig = populateConfig;
        this.valueFactory = new ValueFactory(populateConfig.useRandomValues(), populateConfig.getOverridePopulate());
    }

    public <T> T populate(Class<T> clazz) {
        ObjectFactory objectFactory = this.populateConfig.isObjectFactoryEnabled() ? new ObjectFactoryImpl(this.populateConfig) : new ObjectFactoryVoid();
        T t = this.populateWithOverrides(CollectionCarrier.initialize(clazz, objectFactory));
        objectFactory.writeToFile();
        return t;
    }

    private <T> T populateWithOverrides(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        if (this.valueFactory.hasType(clazz)) {
            return this.creatValue(classCarrier);
        }
        if (PopulateUtil.alreadyVisited(classCarrier, this.populateConfig.isNullOnCircularDependency())) {
            return PopulateFactory.createNullValue(classCarrier);
        }
        if (PopulateUtil.isCollectionCarrier(classCarrier)) {
            return this.continuePopulateForCollection((CollectionCarrier)classCarrier);
        }
        if (clazz.isArray()) {
            return this.continuePopulateForArray(classCarrier);
        }
        return this.continuePopulateWithStrategies(classCarrier);
    }

    private <T> T creatValue(ClassCarrier<T> classCarrier) {
        T value = this.valueFactory.createValue(classCarrier.getClazz());
        classCarrier.getObjectFactory().value(value);
        return value;
    }

    private static <T> T createNullValue(ClassCarrier<T> classCarrier) {
        classCarrier.getObjectFactory().nullValue(classCarrier.getClazz());
        return null;
    }

    private <T> T continuePopulateForArray(ClassCarrier<T> classCarrier) {
        Class<?> componentType = classCarrier.getClazz().getComponentType();
        classCarrier.getObjectFactory().array(componentType);
        Object value = this.populateWithOverrides(classCarrier.toClassCarrier(componentType));
        Object array = Array.newInstance(componentType, 1);
        Array.set(array, 0, value);
        return (T)array;
    }

    private <T> T continuePopulateForCollection(CollectionCarrier<T> collectionCarrier) {
        try {
            Class clazz = collectionCarrier.getClazz();
            if (PopulateUtil.isMap(clazz)) {
                return this.continuePopulateForMap(collectionCarrier);
            }
            if (PopulateUtil.isSet(clazz)) {
                return this.continuePopulateForSet(collectionCarrier);
            }
            if (PopulateUtil.isMapEntry(clazz)) {
                return this.continuePopulateForMapEntry(collectionCarrier);
            }
            if (PopulateUtil.isCollection(clazz)) {
                return this.continuePopulateForList(collectionCarrier);
            }
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_COLLECTION, collectionCarrier.getClazz().getTypeName()), e);
        }
        throw new PopulateException(String.format(MISSING_COLLECTION_TYPE, collectionCarrier.getClazz().getTypeName()));
    }

    private <T> T continuePopulateForMap(CollectionCarrier<T> classCarrier) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (PopulateUtil.hasConstructors(classCarrier)) {
            classCarrier.getObjectFactory().map(classCarrier.getClazz());
            Map map = (Map)classCarrier.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
            Optional<Object> key = Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0))));
            Optional<Object> value = Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(1))));
            key.ifPresent(k -> map.put(k, value.orElse(null)));
            return (T)map;
        }
        classCarrier.getObjectFactory().mapOf();
        Optional<Object> key = Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0))));
        Optional<Object> value = Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(1))));
        if (key.isPresent() && value.isPresent()) {
            return (T)Map.of(key.get(), value.get());
        }
        return (T)Map.of();
    }

    private <T> T continuePopulateForSet(CollectionCarrier<T> classCarrier) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (PopulateUtil.hasConstructors(classCarrier)) {
            classCarrier.getObjectFactory().set(classCarrier.getClazz());
            Set set = (Set)classCarrier.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
            Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0)))).ifPresent(set::add);
            return (T)set;
        }
        classCarrier.getObjectFactory().setOf();
        return (T)Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0)))).map(value -> Set.of(value)).orElseGet(() -> Set.of());
    }

    private <T> T continuePopulateForMapEntry(CollectionCarrier<T> classCarrier) {
        classCarrier.getObjectFactory().mapEntry(classCarrier.getClazz());
        Object key = this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0)));
        Object value = this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(1)));
        return (T)new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    private <T> T continuePopulateForList(CollectionCarrier<T> classCarrier) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (PopulateUtil.hasConstructors(classCarrier)) {
            classCarrier.getObjectFactory().list(classCarrier.getClazz());
            List list = (List)classCarrier.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
            Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0)))).ifPresent(list::add);
            return (T)list;
        }
        classCarrier.getObjectFactory().listOf();
        return (T)Optional.ofNullable(this.continuePopulateWithType(classCarrier.toTypeCarrier(classCarrier.getArgumentTypes().get(0)))).map(value -> List.of(value)).orElseGet(() -> List.of());
    }

    private Object continuePopulateWithType(TypeCarrier typeCarrier) {
        Type type = typeCarrier.getType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.populateWithOverrides(typeCarrier.toCollectionCarrier(parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()));
        }
        return this.populateWithOverrides(typeCarrier.toClassCarrier(type));
    }

    private <T> T continuePopulateWithStrategies(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        for (Strategy strategy : this.populateConfig.getStrategyOrder()) {
            if (PopulateUtil.isMatchingConstructorStrategy(strategy, clazz, this.populateConfig.canAccessNonPublicConstructors())) {
                return this.continuePopulateUsingConstructor(classCarrier);
            }
            if (PopulateUtil.isMatchingSetterStrategy(strategy, clazz, this.populateConfig.getSetterPrefixes(), this.populateConfig.canAccessNonPublicConstructors())) {
                return this.continuePopulateUsingSetters(classCarrier);
            }
            if (PopulateUtil.isMatchingMutatorStrategy(strategy, clazz, this.populateConfig.canAccessNonPublicConstructors(), this.populateConfig.getConstructorType())) {
                return this.continuePopulateUsingMutator(classCarrier);
            }
            if (PopulateUtil.isMatchingFieldStrategy(strategy, clazz, this.populateConfig.canAccessNonPublicConstructors())) {
                return this.continuePopulateUsingFields(classCarrier);
            }
            if (!PopulateUtil.isMatchingBuilderStrategy(strategy, clazz, this.populateConfig.getBuilderPattern())) continue;
            return this.continuePopulateUsingBuilder(classCarrier);
        }
        throw new PopulateException(String.format(NO_MATCHING_STRATEGY, clazz.getName(), this.populateConfig.getStrategyOrder()));
    }

    private <T> T continuePopulateUsingConstructor(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        try {
            Constructor<T> constructor = PopulateUtil.getLargestConstructor(clazz, this.populateConfig.canAccessNonPublicConstructors());
            PopulateUtil.setAccessible(constructor, this.populateConfig.canAccessNonPublicConstructors());
            return this.continuePopulateUsingConstructor(constructor, classCarrier);
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, new Object[]{clazz.getName(), Strategy.CONSTRUCTOR}), e);
        }
    }

    private <T> T continuePopulateUsingConstructor(Constructor<T> constructor, ClassCarrier<T> classCarrier) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        classCarrier.getObjectFactory().constructor(classCarrier.getClazz(), constructor.getParameterCount());
        Object[] arguments = IntStream.range(0, constructor.getParameterCount()).mapToObj(i -> {
            Parameter parameter = constructor.getParameters()[i];
            if (PopulateUtil.isCollection(parameter.getType())) {
                return this.populateWithOverrides(classCarrier.toCollectionCarrier(parameter));
            }
            return this.populateWithOverrides(classCarrier.toClassCarrier(parameter));
        }).toArray();
        return constructor.newInstance(arguments);
    }

    private <T> T continuePopulateUsingFields(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            PopulateUtil.setAccessible(constructor, this.populateConfig.canAccessNonPublicConstructors());
            Object objectOfClass = constructor.newInstance(new Object[0]);
            PopulateUtil.getDeclaredFields(clazz, this.populateConfig.getBlacklistedFields()).stream().filter(field -> !Modifier.isFinal(field.getModifiers())).forEach(field -> {
                try {
                    PopulateUtil.setAccessible(field, objectOfClass);
                    if (PopulateUtil.isCollection(field.getType())) {
                        field.set(objectOfClass, this.populateWithOverrides(classCarrier.toCollectionCarrier(field.getType(), ((ParameterizedType)field.getGenericType()).getActualTypeArguments())));
                    } else {
                        field.set(objectOfClass, this.populateWithOverrides(classCarrier.toClassCarrier(field.getType())));
                    }
                }
                catch (Exception e) {
                    throw new PopulateException(String.format(FAILED_TO_SET_FIELD, field.getName(), objectOfClass.getClass().getName()), e);
                }
            });
            return objectOfClass;
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, new Object[]{clazz.getName(), Strategy.FIELD}), e);
        }
    }

    private <T> T continuePopulateUsingSetters(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            PopulateUtil.setAccessible(constructor, this.populateConfig.canAccessNonPublicConstructors());
            Object objectOfClass = constructor.newInstance(new Object[0]);
            List<Method> methods = PopulateUtil.getSetterMethods(clazz, this.populateConfig.getBlacklistedMethods(), this.populateConfig.getSetterPrefixes());
            classCarrier.getObjectFactory().setter(clazz, methods.size());
            methods.forEach(method -> this.continuePopulateForMethod((Object)objectOfClass, (Method)method, classCarrier));
            return objectOfClass;
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, new Object[]{clazz.getName(), Strategy.SETTER}), e);
        }
    }

    private <T> T continuePopulateUsingMutator(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        try {
            Constructor<T> constructor = PopulateUtil.getConstructor(clazz, this.populateConfig.canAccessNonPublicConstructors(), this.populateConfig.getConstructorType());
            PopulateUtil.setAccessible(constructor, this.populateConfig.canAccessNonPublicConstructors());
            if (constructor.getParameterCount() > 0) {
                Object objectOfClass = this.continuePopulateUsingConstructor(constructor, classCarrier);
                List<Method> methods = PopulateUtil.getMutatorMethods(clazz, this.populateConfig.getBlacklistedMethods());
                classCarrier.getObjectFactory().mutator(clazz, methods.size());
                methods.forEach(method -> this.continuePopulateForMethod((Object)objectOfClass, (Method)method, classCarrier));
                return objectOfClass;
            }
            Object objectOfClass = constructor.newInstance(new Object[0]);
            List<Method> methods = PopulateUtil.getMutatorMethods(clazz, this.populateConfig.getBlacklistedMethods());
            classCarrier.getObjectFactory().setter(clazz, methods.size());
            methods.forEach(method -> this.continuePopulateForMethod((Object)objectOfClass, (Method)method, classCarrier));
            return objectOfClass;
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, new Object[]{clazz.getName(), Strategy.MUTATOR}), e);
        }
    }

    private <T> T continuePopulateUsingBuilder(ClassCarrier<T> classCarrier) {
        switch (this.populateConfig.getBuilderPattern()) {
            case LOMBOK: {
                return this.continuePopulateUsingLombokBuilder(classCarrier);
            }
            case IMMUTABLES: {
                return this.continuePopulateUsingImmutablesBuilder(classCarrier);
            }
        }
        throw new PopulateException("Unsupported builder pattern");
    }

    private <T> T continuePopulateUsingLombokBuilder(ClassCarrier<T> classCarrier) {
        Class<T> clazz = classCarrier.getClazz();
        try {
            Object builderObject = clazz.getDeclaredMethod(BUILDER_METHOD, new Class[0]).invoke(null, new Object[0]);
            Map<Integer, List<Method>> builderObjectMethodsGroupedByInvokeOrder = LombokUtil.getMethodsForLombokBuilderGroupedByInvokeOrder(builderObject.getClass(), this.populateConfig.getBlacklistedMethods());
            classCarrier.getObjectFactory().builder(clazz, LombokUtil.calculateExpectedChildren(builderObjectMethodsGroupedByInvokeOrder));
            Optional.ofNullable(builderObjectMethodsGroupedByInvokeOrder.get(1)).ifPresent(methods -> methods.forEach(method -> this.continuePopulateForMethod((Object)builderObject, (Method)method, classCarrier)));
            Optional.ofNullable(builderObjectMethodsGroupedByInvokeOrder.get(2)).ifPresent(methods -> methods.forEach(method -> this.continuePopulateForMethod((Object)builderObject, (Method)method, classCarrier)));
            Optional.ofNullable(builderObjectMethodsGroupedByInvokeOrder.get(3)).ifPresent(methods -> methods.forEach(method -> this.continuePopulateForMethod((Object)builderObject, (Method)method, classCarrier)));
            Method buildMethod = builderObject.getClass().getDeclaredMethod(BUILD_METHOD, new Class[0]);
            PopulateUtil.setAccessible(buildMethod, builderObject);
            return (T)buildMethod.invoke(builderObject, new Object[0]);
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, clazz.getName(), String.format("%s (%s)", new Object[]{Strategy.BUILDER, BuilderPattern.LOMBOK})), e);
        }
    }

    private <T> T continuePopulateUsingImmutablesBuilder(ClassCarrier<T> classCarrier) {
        try {
            Class<?> immutablesGeneratedClass = ImmutablesUtil.getImmutablesGeneratedClass(classCarrier.getClazz());
            Object builderObject = immutablesGeneratedClass.getDeclaredMethod(BUILDER_METHOD, new Class[0]).invoke(null, new Object[0]);
            List<Method> builderObjectMethods = ImmutablesUtil.getMethodsForImmutablesBuilder(immutablesGeneratedClass, builderObject, this.populateConfig.getBlacklistedMethods());
            classCarrier.getObjectFactory().builder(immutablesGeneratedClass, builderObjectMethods.size());
            builderObjectMethods.forEach(method -> this.continuePopulateForMethod((Object)builderObject, (Method)method, classCarrier));
            Method buildMethod = builderObject.getClass().getDeclaredMethod(BUILD_METHOD, new Class[0]);
            return (T)buildMethod.invoke(builderObject, new Object[0]);
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CREATE_OBJECT, classCarrier.getClazz().getName(), String.format("%s (%s)", new Object[]{Strategy.BUILDER, BuilderPattern.IMMUTABLES})), e);
        }
    }

    private <T, V> void continuePopulateForMethod(V objectOfClass, Method method, ClassCarrier<T> classCarrier) {
        try {
            classCarrier.getObjectFactory().method(method.getName(), method.getParameters().length);
            method.invoke(objectOfClass, Stream.of(method.getParameters()).map(parameter -> {
                if (PopulateUtil.isCollection(parameter.getType())) {
                    return this.populateWithOverrides(classCarrier.toCollectionCarrier((Parameter)parameter));
                }
                return this.populateWithOverrides(classCarrier.toClassCarrier((Parameter)parameter));
            }).toArray());
        }
        catch (Exception e) {
            throw new PopulateException(String.format(FAILED_TO_CALL_METHOD, method.getName(), objectOfClass.getClass().getName()), e);
        }
    }
}

