/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.config;

import com.github.anhem.testpopulator.config.BuilderPattern;
import com.github.anhem.testpopulator.config.ConstructorType;
import com.github.anhem.testpopulator.config.OverridePopulate;
import com.github.anhem.testpopulator.config.Strategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PopulateConfig {
    public static final String INVALID_CONFIG_MISSING_BUILDER_PATTERN = "%s strategy configured, but no builderPattern specified. Should be one of %s";
    public static final String INVALID_CONFIG_NON_PUBLIC_CONSTRUCTOR_AND_OBJECT_FACTORY = "objectFactory can not be enabled while accessNonPublicConstructors is true";
    public static final String INVALID_CONFIG_FIELD_STRATEGY_AND_OBJECT_FACTORY = "objectFactory can not be enabled while strategyOrder contains FIELD";
    public static final List<String> DEFAULT_BLACKLISTED_METHODS = List.of("$jacocoInit");
    public static final List<String> DEFAULT_BLACKLISTED_FIELDS = List.of("__$lineHits$__", "$jacocoData");
    public static final List<Strategy> DEFAULT_STRATEGY_ORDER = List.of(Strategy.CONSTRUCTOR, Strategy.SETTER);
    public static final boolean DEFAULT_RANDOM_VALUES = true;
    public static final boolean DEFAULT_ACCESS_NON_PUBLIC_CONSTRUCTORS = false;
    public static final List<String> DEFAULT_SETTER_PREFIXES = List.of("set");
    public static final boolean DEFAULT_OBJECT_FACTORY_ENABLED = false;
    public static final boolean DEFAULT_NULL_ON_CIRCULAR_DEPENDENCY = false;
    public static final ConstructorType DEFAULT_CONSTRUCTOR_TYPE = ConstructorType.NO_ARGS;
    private final List<String> blacklistedMethods;
    private final List<String> blacklistedFields;
    private final List<Strategy> strategyOrder;
    private final Map<Class<?>, OverridePopulate<?>> overridePopulate;
    private final BuilderPattern builderPattern;
    private final boolean randomValues;
    private final boolean accessNonPublicConstructors;
    private final List<String> setterPrefixes;
    private final boolean objectFactoryEnabled;
    private final boolean nullOnCircularDependency;
    private final ConstructorType constructorType;

    public static PopulateConfigBuilder builder() {
        return new PopulateConfigBuilder();
    }

    private PopulateConfig(List<String> blacklistedMethods, List<String> blacklistedFields, List<Strategy> strategyOrder, Map<Class<?>, OverridePopulate<?>> overridePopulate, BuilderPattern builderPattern, Boolean randomValues, Boolean accessNonPublicConstructors, List<String> setterPrefixes, Boolean objectFactoryEnabled, Boolean nullOnCircularDependency, ConstructorType constructorType) {
        this.blacklistedMethods = blacklistedMethods.isEmpty() ? DEFAULT_BLACKLISTED_METHODS : blacklistedMethods;
        this.blacklistedFields = blacklistedFields.isEmpty() ? DEFAULT_BLACKLISTED_FIELDS : blacklistedFields;
        this.strategyOrder = strategyOrder.isEmpty() ? DEFAULT_STRATEGY_ORDER : strategyOrder;
        this.overridePopulate = overridePopulate;
        this.builderPattern = builderPattern;
        this.randomValues = randomValues == null ? true : randomValues;
        this.accessNonPublicConstructors = accessNonPublicConstructors == null ? false : accessNonPublicConstructors;
        this.setterPrefixes = setterPrefixes.isEmpty() ? DEFAULT_SETTER_PREFIXES : setterPrefixes;
        this.objectFactoryEnabled = objectFactoryEnabled == null ? false : objectFactoryEnabled;
        this.nullOnCircularDependency = nullOnCircularDependency == null ? false : nullOnCircularDependency;
        this.constructorType = constructorType == null ? DEFAULT_CONSTRUCTOR_TYPE : constructorType;
    }

    public List<String> getBlacklistedMethods() {
        return this.blacklistedMethods;
    }

    public List<String> getBlacklistedFields() {
        return this.blacklistedFields;
    }

    public List<Strategy> getStrategyOrder() {
        return this.strategyOrder;
    }

    public Map<Class<?>, OverridePopulate<?>> getOverridePopulate() {
        return this.overridePopulate;
    }

    public BuilderPattern getBuilderPattern() {
        return this.builderPattern;
    }

    public boolean useRandomValues() {
        return this.randomValues;
    }

    public boolean canAccessNonPublicConstructors() {
        return this.accessNonPublicConstructors;
    }

    public List<String> getSetterPrefixes() {
        return this.setterPrefixes;
    }

    public boolean isObjectFactoryEnabled() {
        return this.objectFactoryEnabled;
    }

    public boolean isNullOnCircularDependency() {
        return this.nullOnCircularDependency;
    }

    public ConstructorType getConstructorType() {
        return this.constructorType;
    }

    public PopulateConfigBuilder toBuilder() {
        return PopulateConfig.builder().blacklistedMethods(new ArrayList<String>(this.blacklistedMethods)).blacklistedFields(new ArrayList<String>(this.blacklistedFields)).strategyOrder(new ArrayList<Strategy>(this.strategyOrder)).overridePopulate(new ArrayList(this.overridePopulate.values())).builderPattern(this.builderPattern).randomValues(this.randomValues).accessNonPublicConstructors(this.accessNonPublicConstructors).setterPrefixes(new ArrayList<String>(this.setterPrefixes)).objectFactoryEnabled(this.objectFactoryEnabled).nullOnCircularDependency(this.nullOnCircularDependency).constructorType(this.constructorType);
    }

    private void validate() {
        if (this.strategyOrder.contains((Object)Strategy.BUILDER) && this.builderPattern == null) {
            throw new IllegalArgumentException(String.format(INVALID_CONFIG_MISSING_BUILDER_PATTERN, new Object[]{Strategy.BUILDER, Arrays.toString((Object[])BuilderPattern.values())}));
        }
        if (this.accessNonPublicConstructors && this.objectFactoryEnabled) {
            throw new IllegalArgumentException(INVALID_CONFIG_NON_PUBLIC_CONSTRUCTOR_AND_OBJECT_FACTORY);
        }
        if (this.strategyOrder.contains((Object)Strategy.FIELD) && this.objectFactoryEnabled) {
            throw new IllegalArgumentException(INVALID_CONFIG_FIELD_STRATEGY_AND_OBJECT_FACTORY);
        }
    }

    public String toString() {
        return "PopulateConfig{blacklistedMethods=" + this.blacklistedMethods + ", blacklistedFields=" + this.blacklistedFields + ", strategyOrder=" + this.strategyOrder + ", overridePopulate=" + this.overridePopulate + ", builderPattern=" + this.builderPattern + ", randomValues=" + this.randomValues + ", accessNonPublicConstructors=" + this.accessNonPublicConstructors + ", setterPrefixes=" + this.setterPrefixes + ", objectFactoryEnabled=" + this.objectFactoryEnabled + ", nullOnCircularDependency=" + this.nullOnCircularDependency + ", constructorType=" + this.constructorType + "}";
    }

    public static class PopulateConfigBuilder {
        private List<String> blacklistedMethods = new ArrayList<String>();
        private List<String> blacklistedFields = new ArrayList<String>();
        private List<Strategy> strategyOrder = new ArrayList<Strategy>();
        private Map<Class<?>, OverridePopulate<?>> overridePopulate = new HashMap();
        private BuilderPattern builderPattern;
        private Boolean randomValues;
        private Boolean accessNonPublicConstructors;
        private List<String> setterPrefixes = new ArrayList<String>();
        private Boolean objectFactoryEnabled;
        private Boolean nullOnCircularDependency;
        private ConstructorType constructorType;

        public PopulateConfigBuilder blacklistedMethods(List<String> blacklistedMethods) {
            this.blacklistedMethods = blacklistedMethods;
            return this;
        }

        public PopulateConfigBuilder blacklistedFields(List<String> blacklistedFields) {
            this.blacklistedFields = blacklistedFields;
            return this;
        }

        public PopulateConfigBuilder strategyOrder(List<Strategy> strategyOrder) {
            this.strategyOrder = strategyOrder;
            return this;
        }

        public PopulateConfigBuilder strategyOrder(Strategy strategy) {
            this.strategyOrder.add(strategy);
            return this;
        }

        @Deprecated
        public PopulateConfigBuilder overridePopulate(List<OverridePopulate<?>> overridePopulates) {
            this.overridePopulate = new HashMap();
            overridePopulates.forEach(this::overridePopulate);
            return this;
        }

        @Deprecated
        public PopulateConfigBuilder overridePopulate(OverridePopulate<?> overridePopulate) {
            this.overridePopulate.put(overridePopulate.create().getClass(), overridePopulate);
            return this;
        }

        public PopulateConfigBuilder overridePopulate(Map<Class<?>, OverridePopulate<?>> overridePopulates) {
            this.overridePopulate = overridePopulates;
            return this;
        }

        public PopulateConfigBuilder overridePopulate(Class<?> clazz, OverridePopulate<?> overridePopulate) {
            this.overridePopulate.put(clazz, overridePopulate);
            return this;
        }

        public PopulateConfigBuilder builderPattern(BuilderPattern builderPattern) {
            this.builderPattern = builderPattern;
            return this;
        }

        public PopulateConfigBuilder randomValues(boolean randomValues) {
            this.randomValues = randomValues;
            return this;
        }

        public PopulateConfigBuilder accessNonPublicConstructors(boolean accessNonPublicConstructor) {
            this.accessNonPublicConstructors = accessNonPublicConstructor;
            return this;
        }

        public PopulateConfigBuilder setterPrefixes(List<String> setterPrefixes) {
            this.setterPrefixes = setterPrefixes;
            return this;
        }

        public PopulateConfigBuilder setterPrefix(String setterPrefix) {
            this.setterPrefixes.add(setterPrefix);
            return this;
        }

        public PopulateConfigBuilder objectFactoryEnabled(boolean objectFactoryEnabled) {
            this.objectFactoryEnabled = objectFactoryEnabled;
            return this;
        }

        public PopulateConfigBuilder nullOnCircularDependency(boolean nullOnCircularDependency) {
            this.nullOnCircularDependency = nullOnCircularDependency;
            return this;
        }

        public PopulateConfigBuilder constructorType(ConstructorType constructorType) {
            this.constructorType = constructorType;
            return this;
        }

        public PopulateConfig build() {
            PopulateConfig populateConfig = new PopulateConfig(this.blacklistedMethods, this.blacklistedFields, this.strategyOrder, this.overridePopulate, this.builderPattern, this.randomValues, this.accessNonPublicConstructors, this.setterPrefixes, this.objectFactoryEnabled, this.nullOnCircularDependency, this.constructorType);
            populateConfig.validate();
            return populateConfig;
        }
    }
}

