/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.object;

import com.github.anhem.testpopulator.exception.ObjectException;
import com.github.anhem.testpopulator.internal.object.BuildType;
import com.github.anhem.testpopulator.internal.object.ObjectResult;
import com.github.anhem.testpopulator.internal.util.ObjectBuilderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectBuilder {
    public static final String NULL = "null";
    public static final String PSF = "public static final";
    private static final String NEW_OBJECT_WITH_ARGUMENTS = "%s %s %s = new %s(%s);";
    private static final String NEW_OBJECT = "%s %s %s = new %s();";
    private static final String BUILDER = "%s %s %s = %s.%s()";
    private static final String NEW_TYPED_OBJECT = "%s %s<%s> %s = new %s<>();";
    private static final String SET_OF = "%s %s<%s> %s = Set.of(%s);";
    private static final String LIST_OF = "%s %s<%s> %s = List.of(%s);";
    private static final String MAP_OF = "%s %s<%s> %s = Map.of(%s);";
    private static final String MAP_ENTRY = "%s %s<%s> %s = new AbstractMap.SimpleEntry<>(%s);";
    private static final String NEW_ARRAY = "%s %s[] %s = new %s[]{%s};";
    private static final String NEW_VALUE = "%s %s %s = %s;";
    private static final String ARGUMENT_DELIMITER = ", ";
    private Class<?> clazz;
    private final String name;
    private final BuildType buildType;
    private final List<ObjectBuilder> children = new ArrayList<ObjectBuilder>();
    private final int expectedChildren;
    private ObjectBuilder parent;
    private String value;

    public ObjectBuilder(Class<?> clazz, String name, BuildType buildType, int expectedChildren) {
        this.clazz = clazz;
        this.name = name;
        this.buildType = buildType;
        this.expectedChildren = expectedChildren;
    }

    public ObjectBuilder(String name, BuildType buildType, int expectedChildren) {
        this.name = name;
        this.buildType = buildType;
        this.expectedChildren = expectedChildren;
    }

    public void addChild(ObjectBuilder child) {
        this.children.add(child);
    }

    public List<ObjectBuilder> getChildren() {
        return this.children;
    }

    public boolean hasAllChildren() {
        return this.expectedChildren == this.children.size();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public ObjectBuilder getParent() {
        return this.parent;
    }

    public void setParent(ObjectBuilder parent) {
        this.parent = parent;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ObjectResult build() {
        String packageName = ObjectBuilderUtil.getPackageName(this.clazz);
        String className = ObjectBuilderUtil.formatClassName(this.clazz);
        HashSet<String> imports = new HashSet<String>();
        HashSet<String> staticImports = new HashSet<String>();
        this.getImports(imports, staticImports);
        List<String> objects = this.buildByBuildType();
        return new ObjectResult(packageName, className, imports, staticImports, objects);
    }

    private void getImports(Set<String> imports, Set<String> staticImports) {
        ObjectBuilderUtil.addImport(this.clazz, this.value, imports, staticImports);
        this.children.forEach(objectBuilder -> objectBuilder.getImports(imports, staticImports));
    }

    private List<String> buildByBuildType() {
        switch (this.buildType) {
            case CONSTRUCTOR: {
                return this.buildConstructor();
            }
            case SETTER: {
                return this.buildSetter();
            }
            case BUILDER: {
                return this.buildBuilder();
            }
            case METHOD: {
                return this.buildMethod();
            }
            case SET: {
                return this.buildSet();
            }
            case SET_OF: {
                return this.buildSetOf();
            }
            case LIST: {
                return this.buildList();
            }
            case LIST_OF: {
                return this.buildListOf();
            }
            case MAP: {
                return this.buildMap();
            }
            case MAP_OF: {
                return this.buildMapOf();
            }
            case MAP_ENTRY: {
                return this.buildMapEntry();
            }
            case ARRAY: {
                return this.buildArray();
            }
            case VALUE: {
                return this.buildValue();
            }
            case MUTATOR: {
                return this.buildMutator();
            }
        }
        throw new ObjectException(String.format("Invalid buildType %s", new Object[]{this.buildType}));
    }

    private Stream<String> buildChildren() {
        return this.buildChildren(this.children);
    }

    private Stream<String> buildChildren(List<ObjectBuilder> children) {
        return children.stream().filter(child -> !ObjectBuilderUtil.isBasicValue(child)).map(ObjectBuilder::buildByBuildType).flatMap(Collection::stream);
    }

    private List<String> buildConstructor() {
        if (this.children.stream().anyMatch(child -> child.buildType == BuildType.MUTATOR)) {
            Map<Boolean, List<ObjectBuilder>> childrenByMutator = this.children.stream().collect(Collectors.groupingBy(child -> child.getBuildType() == BuildType.MUTATOR));
            List<ObjectBuilder> mutatorChildren = childrenByMutator.getOrDefault(true, Collections.emptyList());
            List<ObjectBuilder> otherChildren = childrenByMutator.getOrDefault(false, Collections.emptyList());
            return ObjectBuilderUtil.concatenate(this.buildChildren(otherChildren), Stream.of(String.format(NEW_OBJECT_WITH_ARGUMENTS, PSF, this.clazz.getSimpleName(), this.name, this.clazz.getSimpleName(), this.buildArguments(otherChildren))), this.buildChildren(mutatorChildren)).collect(Collectors.toList());
        }
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(NEW_OBJECT_WITH_ARGUMENTS, PSF, this.clazz.getSimpleName(), this.name, this.clazz.getSimpleName(), this.buildArguments()))).collect(Collectors.toList());
    }

    private List<String> buildSetter() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(NEW_OBJECT, PSF, this.clazz.getSimpleName(), this.name, this.clazz.getSimpleName())), ObjectBuilderUtil.startStaticBlock(), this.createMethods(), ObjectBuilderUtil.endStaticBlock()).collect(Collectors.toList());
    }

    private List<String> buildMutator() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), ObjectBuilderUtil.startStaticBlock(), this.createMethods(), ObjectBuilderUtil.endStaticBlock()).collect(Collectors.toList());
    }

    private List<String> buildBuilder() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(BUILDER, PSF, this.clazz.getSimpleName(), this.name, this.clazz.getSimpleName(), "builder")), this.createMethods(), ObjectBuilderUtil.endBuilder()).collect(Collectors.toList());
    }

    private List<String> buildMethod() {
        return this.buildChildren().collect(Collectors.toList());
    }

    private List<String> buildSet() {
        return this.buildCollection();
    }

    private List<String> buildSetOf() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(SET_OF, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, ObjectBuilder.getNullableArguments(this.buildArguments())))).collect(Collectors.toList());
    }

    private List<String> buildList() {
        return this.buildCollection();
    }

    private List<String> buildListOf() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(LIST_OF, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, ObjectBuilder.getNullableArguments(this.buildArguments())))).collect(Collectors.toList());
    }

    private List<String> buildMap() {
        return this.buildCollection();
    }

    private List<String> buildMapOf() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(MAP_OF, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, ObjectBuilder.getNullableArguments(this.buildArguments())))).collect(Collectors.toList());
    }

    private List<String> buildMapEntry() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(MAP_ENTRY, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, this.buildArguments()))).collect(Collectors.toList());
    }

    private List<String> buildArray() {
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(NEW_ARRAY, PSF, this.clazz.getSimpleName(), this.name, this.clazz.getSimpleName(), this.buildArguments()))).collect(Collectors.toList());
    }

    private List<String> buildCollection() {
        if (ObjectBuilderUtil.collectionHasNullValues(this)) {
            return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(NEW_TYPED_OBJECT, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, this.clazz.getSimpleName()))).collect(Collectors.toList());
        }
        return ObjectBuilderUtil.concatenate(this.buildChildren(), Stream.of(String.format(NEW_TYPED_OBJECT, PSF, this.clazz.getSimpleName(), this.formatTypes(), this.name, this.clazz.getSimpleName())), ObjectBuilderUtil.startStaticBlock(), this.createMethods(), ObjectBuilderUtil.endStaticBlock()).collect(Collectors.toList());
    }

    private List<String> buildValue() {
        if (this.isNullValue()) {
            return List.of();
        }
        return List.of(String.format(NEW_VALUE, PSF, this.clazz.getSimpleName(), this.name, this.value));
    }

    public boolean isNullValue() {
        return this.value != null && this.value.equals(NULL);
    }

    private Stream<String> createMethods() {
        return this.children.stream().map(child -> this.buildType == BuildType.BUILDER ? String.format(".%s(%s)", child.getName(), child.buildArguments()) : String.format("%s.%s(%s);", this.name, child.getName(), child.buildArguments()));
    }

    private static String getNullableArguments(String buildArguments) {
        return Arrays.asList(buildArguments.split(ARGUMENT_DELIMITER)).contains(NULL) ? "" : buildArguments;
    }

    private String buildArguments() {
        return this.buildArguments(this.children);
    }

    private String buildArguments(List<ObjectBuilder> children) {
        return children.stream().map(child -> {
            if (child.isNullValue()) {
                return List.of(NULL);
            }
            if (ObjectBuilderUtil.isBasicValue(child)) {
                return child.buildInlineArgument();
            }
            return List.of(child.getName());
        }).flatMap(Collection::stream).collect(Collectors.joining(ARGUMENT_DELIMITER));
    }

    private List<String> buildInlineArgument() {
        return List.of(this.value);
    }

    private String formatTypes() {
        return this.children.stream().map(child -> {
            if (child.getClazz() == null) {
                return child.formatTypes();
            }
            if (child.getBuildType().isParameterizedType()) {
                return String.format("%s<%s>", child.getClazz().getSimpleName(), child.formatTypes());
            }
            return child.getClazz().getSimpleName();
        }).collect(Collectors.joining(ARGUMENT_DELIMITER));
    }
}

