/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.object;

import com.github.anhem.testpopulator.config.PopulateConfig;
import com.github.anhem.testpopulator.exception.ObjectException;
import com.github.anhem.testpopulator.internal.object.BuildType;
import com.github.anhem.testpopulator.internal.object.ObjectBuilder;
import com.github.anhem.testpopulator.internal.object.ObjectFactory;
import com.github.anhem.testpopulator.internal.object.ObjectResult;
import com.github.anhem.testpopulator.internal.util.FileWriterUtil;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

public class ObjectFactoryImpl
implements ObjectFactory {
    static final String UNSUPPORTED_TYPE = "Failed to find type to create value for %s. Not implemented?";
    private static final Map<Class<?>, Function<Object, String>> stringSuppliers = new HashMap();
    private final PopulateConfig populateConfig;
    private final Map<Class<?>, Integer> classCounters;
    private ObjectBuilder currentObjectBuilder;

    public ObjectFactoryImpl(PopulateConfig populateConfig) {
        this.populateConfig = populateConfig;
        this.classCounters = new HashMap();
    }

    @Override
    public <T> void constructor(Class<T> clazz, int expectedChildren) {
        this.setNextObjectBuilder(clazz, BuildType.CONSTRUCTOR, expectedChildren);
    }

    @Override
    public <T> void setter(Class<T> clazz, int expectedChildren) {
        this.setNextObjectBuilder(clazz, BuildType.SETTER, expectedChildren);
    }

    @Override
    public <T> void mutator(Class<T> clazz, int expectedChildren) {
        this.setNextObjectBuilder(clazz, BuildType.MUTATOR, expectedChildren);
    }

    @Override
    public <T> void builder(Class<T> clazz, int expectedChildren) {
        this.setNextObjectBuilder(clazz, BuildType.BUILDER, expectedChildren);
    }

    @Override
    public void method(String methodName, int expectedChildren) {
        this.setNextObjectBuilder(new ObjectBuilder(methodName, BuildType.METHOD, expectedChildren));
        if (expectedChildren == 0) {
            this.setPreviousObjectBuilder();
        }
    }

    @Override
    public <T> void set(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.SET, 1);
        this.method("add", 1);
    }

    @Override
    public void setOf() {
        this.setNextObjectBuilder(Set.class, BuildType.SET_OF, 1);
    }

    @Override
    public <T> void list(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.LIST, 1);
        this.method("add", 1);
    }

    @Override
    public void listOf() {
        this.setNextObjectBuilder(List.class, BuildType.LIST_OF, 1);
    }

    @Override
    public <T> void map(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.MAP, 1);
        this.method("put", 2);
    }

    @Override
    public void mapOf() {
        this.setNextObjectBuilder(Map.class, BuildType.MAP_OF, 2);
    }

    @Override
    public <T> void mapEntry(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.MAP_ENTRY, 2);
    }

    @Override
    public <T> void array(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.ARRAY, 1);
    }

    @Override
    public <T> void value(T value) {
        this.setNextObjectBuilder(value.getClass(), BuildType.VALUE, 0);
        this.currentObjectBuilder.setValue(this.toStringValue(value));
        this.setPreviousObjectBuilder();
    }

    @Override
    public <T> void nullValue(Class<T> clazz) {
        this.setNextObjectBuilder(clazz, BuildType.VALUE, 0);
        this.currentObjectBuilder.setValue("null");
        this.setPreviousObjectBuilder();
    }

    @Override
    public ObjectResult build() {
        ObjectBuilder topObjectBuilder = this.toTop();
        return topObjectBuilder != null ? topObjectBuilder.build() : ObjectResult.EMPTY_OBJECT_RESULT;
    }

    @Override
    public void writeToFile() {
        ObjectResult objectResult = this.build();
        if (objectResult.isValid()) {
            Path path = FileWriterUtil.getPath(objectResult, this.populateConfig);
            FileWriterUtil.createOrOverwriteFile(path);
            FileWriterUtil.writePackage(objectResult, path);
            FileWriterUtil.writeImports(objectResult, path);
            FileWriterUtil.writeStaticImports(objectResult, path);
            FileWriterUtil.writeStartClass(objectResult, path, this.populateConfig);
            FileWriterUtil.writeObjects(objectResult, path);
            FileWriterUtil.writeEndClass(path);
        }
    }

    private ObjectBuilder toTop() {
        return Stream.iterate(this.currentObjectBuilder, Objects::nonNull, ObjectBuilder::getParent).reduce((child, parent) -> parent).orElse(null);
    }

    private String toStringValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isEnum()) {
            return object.toString();
        }
        return Optional.ofNullable(stringSuppliers.get(clazz)).map((? super T supplier) -> (String)supplier.apply(object)).orElseGet(() -> this.populateConfig.getOverridePopulate().getOrDefault(object.getClass(), () -> {
            throw new ObjectException(String.format(UNSUPPORTED_TYPE, clazz.getTypeName()));
        }).createString());
    }

    private void setNextObjectBuilder(Class<?> clazz, BuildType buildType, int expectedChildren) {
        if (this.currentObjectBuilder == null) {
            this.currentObjectBuilder = new ObjectBuilder(clazz, this.getName(clazz), buildType, expectedChildren);
        } else if (buildType == BuildType.MUTATOR) {
            this.setNextObjectBuilder(new ObjectBuilder(clazz, this.currentObjectBuilder.getName(), buildType, expectedChildren));
        } else {
            this.setNextObjectBuilder(new ObjectBuilder(clazz, this.getName(clazz), buildType, expectedChildren));
        }
    }

    private void setNextObjectBuilder(ObjectBuilder objectBuilder) {
        this.currentObjectBuilder.addChild(objectBuilder);
        objectBuilder.setParent(this.currentObjectBuilder);
        this.currentObjectBuilder = objectBuilder;
    }

    private void setPreviousObjectBuilder() {
        while (this.currentObjectBuilder.getParent() != null && this.currentObjectBuilder.hasAllChildren()) {
            this.currentObjectBuilder = this.currentObjectBuilder.getParent();
        }
    }

    private String getName(Class<?> clazz) {
        int classCounter = this.classCounters.computeIfAbsent(clazz, k -> 0);
        String simpleName = clazz.getSimpleName();
        String name = String.format("%s_%d", Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1), classCounter);
        this.classCounters.put(clazz, ++classCounter);
        return name;
    }

    static {
        stringSuppliers.put(Integer.class, Object::toString);
        stringSuppliers.put(Long.class, object -> object + "L");
        stringSuppliers.put(Double.class, Object::toString);
        stringSuppliers.put(Boolean.class, Object::toString);
        stringSuppliers.put(BigDecimal.class, object -> String.format("BigDecimal.valueOf(%d)", ((BigDecimal)object).intValue()));
        stringSuppliers.put(String.class, object -> "\"" + object + "\"");
        stringSuppliers.put(Character.class, object -> "'" + object + "'");
        stringSuppliers.put(LocalDate.class, object -> String.format("LocalDate.parse(\"%s\")", object));
        stringSuppliers.put(LocalDateTime.class, object -> String.format("LocalDateTime.parse(\"%s\")", object));
        stringSuppliers.put(ZonedDateTime.class, object -> String.format("ZonedDateTime.parse(\"%s\")", object));
        stringSuppliers.put(Instant.class, object -> String.format("Instant.parse(\"%s\")", object));
        stringSuppliers.put(Date.class, object -> String.format("new Date(%sL)", ((Date)object).getTime()));
        stringSuppliers.put(UUID.class, object -> String.format("UUID.fromString(\"%s\")", object));
        stringSuppliers.put(Byte.class, object -> String.format("Byte.parseByte(\"%s\")", object));
        stringSuppliers.put(Short.class, object -> String.format("Short.valueOf(\"%s\")", object));
        stringSuppliers.put(Float.class, object -> object + "f");
    }
}

