/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.util;

import com.github.anhem.testpopulator.config.PopulateConfig;
import com.github.anhem.testpopulator.exception.ObjectException;
import com.github.anhem.testpopulator.internal.object.ObjectResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FileWriterUtil {
    static final String TARGET = "target/generated-test-sources/test-populator";
    private static final String PATH = "target/generated-test-sources/test-populator/%s/%s_%s.java";

    private FileWriterUtil() {
    }

    public static Path getPath(ObjectResult objectResult, PopulateConfig populateConfig) {
        return FileWriterUtil.getPath(objectResult.getPackageName(), objectResult.getClassName(), populateConfig);
    }

    public static Path getPath(String packageName, String className, PopulateConfig populateConfig) {
        return Paths.get(String.format(PATH, FileWriterUtil.toPackagePath(packageName), className, FileWriterUtil.encode(populateConfig)), new String[0]);
    }

    public static void createOrOverwriteFile(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)"", StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new ObjectException(String.format("Could not create or overwrite %s", path.toAbsolutePath()), e);
        }
    }

    public static void writePackage(ObjectResult objectResult, Path path) {
        FileWriterUtil.writeLine(path, String.format("package %s;%s", objectResult.getPackageName(), System.lineSeparator()));
    }

    public static void writeImports(ObjectResult objectResult, Path path) {
        objectResult.getImports().stream().sorted().forEach(s -> FileWriterUtil.writeLine(path, String.format("import %s;", s)));
        FileWriterUtil.writeLine(path, "");
    }

    public static void writeStaticImports(ObjectResult objectResult, Path path) {
        objectResult.getStaticImports().stream().sorted().forEach(s -> FileWriterUtil.writeLine(path, String.format("import static %s;", s)));
        FileWriterUtil.writeLine(path, "");
    }

    public static void writeStartClass(ObjectResult objectResult, Path path, PopulateConfig populateConfig) {
        FileWriterUtil.writeLine(path, String.format("public class %s_%s {%s", objectResult.getClassName(), FileWriterUtil.encode(populateConfig), System.lineSeparator()));
    }

    public static void writeEndClass(Path path) {
        FileWriterUtil.writeLine(path, "}");
    }

    public static void writeObjects(ObjectResult objectResult, Path path) {
        objectResult.getObjects().forEach(s -> {
            if (s.startsWith("static {")) {
                FileWriterUtil.writeLine(path, String.format("%s\t%s", System.lineSeparator(), s));
            } else if (s.startsWith("}")) {
                FileWriterUtil.writeLine(path, String.format("\t%s%s", s, System.lineSeparator()));
            } else if (s.startsWith("public static final")) {
                FileWriterUtil.writeLine(path, String.format("\t%s", s));
            } else {
                FileWriterUtil.writeLine(path, String.format("\t\t%s", s));
            }
        });
    }

    private static void writeLine(Path path, String line) {
        String formattedLine = String.format("%s%s", line, System.lineSeparator());
        try {
            Files.writeString(path, (CharSequence)formattedLine, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new ObjectException(String.format("Write %s to %s failed", formattedLine, path.toAbsolutePath()), e);
        }
    }

    static String encode(PopulateConfig populateConfig) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = messageDigest.digest(populateConfig.toString().getBytes());
            return IntStream.range(0, bytes.length).mapToObj(i -> String.format("%02x", bytes[i])).collect(Collectors.joining());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ObjectException("Could not encode configuration", e);
        }
    }

    static String toPackagePath(String packageName) {
        return packageName.replace(".", "/");
    }
}

